<?php
require "../../connect.php";
require "../../helpers/jwt.php";

$user = getAuthorizedUser();
header('Content-Type: application/json');


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    
    $admin_email = $user->email;
    $stmt = $con->prepare("
        SELECT admins.admin_id, admins.admin_name, admins.admin_phone, admins.admin_image, admins.admin_email, admins.created_at
        FROM admins
        WHERE admin_email = ?
        LIMIT 1
    ");
    $stmt->bind_param('s', $admin_email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        http_response_code(404);
        echo json_encode(['message' => 'Admin Not Found']);
        exit;
    }
    
    $admin = $result->fetch_assoc();
    
    http_response_code(200);
    echo json_encode(['message' => 'Profile Fetched Successfully', $admin]);
    exit;

}else{    
http_response_code(405);
    echo json_encode([
      'message' => 'Method Not Allowed — use POST'
    ]);
    exit;
}