<?php

require "../../connect.php";
require "../../helpers/jwt.php";

header('Content-Type: application/json');
$user = getAuthorizedUser();

$page     = isset($_GET['page'])     ? max(1, (int)$_GET['page'])               : 1;
$per_page = isset($_GET['per_page']) ? min(100, max(1, (int)$_GET['per_page']))  : 10;
$offset   = ($page - 1) * $per_page;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit(json_encode(['message' => 'Method Not Allowed']));
}

$countSql = "SELECT COUNT(DISTINCT order_id) AS total FROM orders";
$countRes = $con->query($countSql);
if (!$countRes) {
    http_response_code(500);
    exit(json_encode([
        'error'   => 'Count query failed',
        'details' => $con->error,
    ]));
}
$total = (int)$countRes->fetch_assoc()['total'];
$total_pages = (int)ceil($total / $per_page);

$input = json_decode(file_get_contents("php://input"), true);

if (!isset($input['order_id'], $input['order_status'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing order_id or order_status']);
    exit;
}

$order_id = $input['order_id'];
$order_status = $input['order_status'];

$stmt = $con->prepare("UPDATE `orders` SET status = ? WHERE order_id = ?");
if (!$stmt) {
    http_response_code(500);
    echo json_encode(['error' => 'Prepare failed']);
    exit;
}

$stmt->bind_param("si", $order_status, $order_id);

if ($stmt->execute()) {
    echo json_encode(['message' => 'Order status updated successfully']);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Execute failed', 'details' => $stmt->error]);
}

$stmt->close();
$con->close();
