
<?php

require "../../connect.php";
require "../../helpers/jwt.php";

header('Content-Type: application/json');
$user = getAuthorizedUser();

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    foreach (['package_text', 'package_text_en', 'package_description', 'package_description_en', 'package_price'] as $field) {
        if (!isset($data[$field])) {
            http_response_code(400);
            echo json_encode(['message' => "Required $field"]);
            exit;
        }
    }
    
    $name = $data['package_text'];
    $name_en = $data['package_text_en'];
    $description_en = $data['package_description_en'];
    $description = $data['package_description'];
    $price = $data['package_price'];

    
    $insert = $con->prepare("INSERT INTO packages (package_text,package_text_en, package_description_en, package_description, package_price) VALUES (?, ?, ?, ?, ?)");
    $insert->bind_param("ssssd", $name,$name_en,$description_en, $description, $price);

    if ($insert->execute()) {
        http_response_code(201);
        echo json_encode(['message' => 'Package Created Successfully']);
    } else {
        http_response_code(500);
        echo json_encode(['message' => 'Failed to Create Package']);
    }

    $insert->close();
    $con->close();

} else {
    http_response_code(405);
    echo json_encode(['message' => 'Method Not Allowed']);
}
