<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require "../../connect.php";

// Make sure we have a request method
$requestMethod = $_SERVER['REQUEST_METHOD'] ?? 'GET';

/**
 * Fallback helper functions in case they are not defined
 * somewhere else (e.g. in connect.php or a common helpers file).
 */
if (!function_exists('error')) {
    function error($msg)
    {
        return json_encode([
            'status'  => 0,
            'message' => $msg,
        ], JSON_UNESCAPED_UNICODE);
    }
}

if (!function_exists('success')) {
    function success($msg)
    {
        return json_encode([
            'status'  => 1,
            'message' => $msg,
        ], JSON_UNESCAPED_UNICODE);
    }
}

if (!function_exists('serverError')) {
    function serverError()
    {
        return json_encode([
            'status'  => 0,
            'message' => 'Server error',
        ], JSON_UNESCAPED_UNICODE);
    }
}

if (!function_exists('error405')) {
    function error405($method)
    {
        return json_encode([
            'status'  => 0,
            'message' => 'Method not allowed: ' . $method,
        ], JSON_UNESCAPED_UNICODE);
    }
}

// Route handler
if ($requestMethod === "POST") {
    $res = addProduct();
    echo $res;
} else {
    echo error405($requestMethod);
}

function addProduct()
{
    global $con;

    $headers = array_change_key_case(getallheaders(), CASE_LOWER);
    $lang    = strtolower(trim($headers['lang'] ?? ''));

    // multipart/form-data → use $_POST + $_FILES
    $obj = $_POST;

    /* =======================
       BASIC FIELD EXISTENCE
       ======================= */

    if (!isset($obj['product_name'])) {
        return error($lang === 'en' ? 'Enter product name in Arabic' : 'ادخل اسم المنتج بالعربي');
    }
    if (!isset($obj['product_name_en'])) {
        return error($lang === 'en' ? 'Enter product name in English' : 'ادخل اسم المنتج بالانجليزية');
    }
    if (!isset($obj['product_description'])) {
        return error($lang === 'en' ? 'Enter product description' : 'ادخل وصف المنتج');
    }
    if (!isset($obj['cat_id'])) {
        return error($lang === 'en' ? 'Enter category ID' : 'ادخل معرف القسم');
    }

    // Main product image must come as file
    if (!isset($_FILES['product_image']) || $_FILES['product_image']['error'] !== UPLOAD_ERR_OK) {
        return error($lang === 'en' ? 'Enter main product image' : 'ادخل الصورة الرئيسية للمنتج');
    }

    // Gallery images as files
    if (!isset($_FILES['images']) || empty($_FILES['images']['name'][0])) {
        return error($lang === 'en' ? 'Enter product images' : 'ادخل صور المنتج');
    }

    /* =======================
       ESCAPE / NORMALIZE FIELDS
       ======================= */
    $sizes           = isset($obj['sizes'])? $obj['sizes']: array(["title"=>"Small", "price"=> 0]);
    $colors           = isset($obj['colors'])?$obj['colors']:null;
    $product_name           = trim($obj['product_name']);
    $product_name_en        = trim($obj['product_name_en']);
    $product_description    = trim($obj['product_description']);
    $product_description_en = isset($obj['product_description_en'])
        ? trim($obj['product_description_en'])
        : '';
    $product_url = "-";          // not used now
    $price_type  = "static";     // fixed type as you set
    $cat_id_raw  = trim($obj['cat_id']); // e.g. "2,3,4"

    /* =======================
       EMPTY / BASIC VALIDATION
       ======================= */

    if ($product_name === '') {
        return error($lang === 'en' ? 'Enter product name in Arabic' : 'ادخل اسم المنتج بالعربي');
    }
    if ($product_name_en === '') {
        return error($lang === 'en' ? 'Enter product name in English' : 'ادخل اسم المنتج بالانجليزي');
    }
    if ($product_description === '') {
        return error($lang === 'en' ? 'Enter product description in Arabic' : 'ادخل وصف المنتج بالعربي');
    }
    if ($product_description_en === '') {
        return error($lang === 'en' ? 'Enter product description in English' : 'ادخل وصف المنتج بالانجليزي');
    }
    if ($cat_id_raw === '') {
        return error($lang === 'en' ? 'Enter product categories ids' : 'ادخل معرفات الأقسام التابع اليها المنتج');
    }
    if ($price_type === '') { // practically always "static" here
        return error($lang === 'en' ? 'Enter product price type' : 'ادخل نوع سعر المنتج');
    }

    // Escape text fields
    $product_name           = mysqli_real_escape_string($con, $product_name);
    $product_name_en        = mysqli_real_escape_string($con, $product_name_en);
    $product_description    = mysqli_real_escape_string($con, $product_description);
    $product_description_en = mysqli_real_escape_string($con, $product_description_en);
    $price_type             = mysqli_real_escape_string($con, $price_type);
    $product_url            = mysqli_real_escape_string($con, $product_url);

    /* =======================
       PRICE HANDLING
       ======================= */

    if ($price_type === "free") {
        $product_price = 0.0;
    } else {
        if (!isset($obj['product_price']) || trim($obj['product_price']) === '') {
            return error($lang === 'en' ? 'Enter product price' : 'ادخل سعر المنتج');
        }

        $product_price_raw = trim($obj['product_price']);
        if (!is_numeric($product_price_raw)) {
            return error($lang === 'en' ? 'Enter valid product price' : 'ادخل سعر منتج صحيح');
        }

        $product_price = (float)$product_price_raw;
    }

    $product_price = mysqli_real_escape_string($con, (string)$product_price);

    /* =======================
       CATEGORIES CHECK (NO SUBCATEGORY)
       ======================= */

    $cats = explode(",", $cat_id_raw);
    foreach ($cats as $cat) {
        $cat = trim($cat);
        if ($cat === '') {
            continue;
        }
        if (!ctype_digit($cat)) {
            return error($lang === 'en' ? "Invalid category ID: $cat" : "معرف قسم غير صحيح: $cat");
        }

        $cat_int    = (int)$cat;
        $sql_select = mysqli_query(
            $con,
            "SELECT * FROM `categories` 
             WHERE `cat_id` = '$cat_int' AND `hidden` = '0' 
             LIMIT 1"
        );
        if (!$sql_select || mysqli_num_rows($sql_select) < 1) {
            return error(
                $lang === 'en'
                    ? "This category $cat_int does not exist"
                    : "هذا القسم $cat_int غير موجود"
            );
        }
    }

    $cat_id = mysqli_real_escape_string($con, $cat_id_raw);

    /* =======================
       HANDLE FILE UPLOADS
       ======================= */

    $uploadDir     = __DIR__ . '/../uploads/products/';
    $uploadUrlBase = 'uploads/products/';

    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    // Allowed extensions (basic check)
    $allowedExt = ['jpg', 'jpeg', 'png', 'webp'];

    // Main product image
    $mainTmpName  = $_FILES['product_image']['tmp_name'];
    $mainOrigName = $_FILES['product_image']['name'];
    $mainExt      = strtolower(pathinfo($mainOrigName, PATHINFO_EXTENSION));

    if (!in_array($mainExt, $allowedExt, true)) {
        return error($lang === 'en' ? 'Invalid main image type' : 'نوع الصورة الرئيسية غير مدعوم');
    }

    $mainFileName = uniqid('prod_main_') . '.' . $mainExt;
    $mainDest     = $uploadDir . $mainFileName;

    if (!move_uploaded_file($mainTmpName, $mainDest)) {
        return serverError(); // failed to move main image
    }

    $product_image = $uploadUrlBase . $mainFileName;

    /* =======================
       INSERT PRODUCT
       (NO location, seller, package, ad_payment, subcategory)
       ======================= */
$product_colors = $colors ? json_encode($colors) : null;
// echo json_encode($colors);echo json_encode($sizes);
    $sql_insert = mysqli_query(
        $con,
        "INSERT INTO `products`
        (`product_name`,`product_name_en`,`product_description`,`product_description_en`,
         `product_price`, `product_url`,`product_image`, `product_catId`, `price_type`, `product_colors`)
         VALUES
        (
         '$product_name',
         '$product_name_en',
         '$product_description',
         '$product_description_en',
         '$product_price',
         '$product_url',
         '$product_image',
         '$cat_id',
         '$price_type',
'$product_colors'
        )"
    );

    if (!$sql_insert) {
        return serverError();
    }

    $product_id = mysqli_insert_id($con);
    
   if($product_id){
    if($sizes){
     

        foreach($sizes as $size){
            $title = mysqli_real_escape_string($con, $size['title']);
            $value = mysqli_real_escape_string($con, $size['price']);

            mysqli_query($con, "INSERT INTO `product_props` 
                (`title`, `value`, `product_id`) 
                VALUES ('$title', '$value', '$product_id')");
        }
    }

}

    if (isset($_FILES['images']) && is_array($_FILES['images']['name'])) {
        $countImages = count($_FILES['images']['name']);

        for ($i = 0; $i < $countImages; $i++) {
            if ($_FILES['images']['error'][$i] !== UPLOAD_ERR_OK) {
                continue;
            }

            $tmpName  = $_FILES['images']['tmp_name'][$i];
            $origName = $_FILES['images']['name'][$i];
            $ext      = strtolower(pathinfo($origName, PATHINFO_EXTENSION));

            if (!in_array($ext, $allowedExt, true)) {
                // skip invalid file types
                continue;
            }

            $fileName = uniqid('prod_img_') . '.' . $ext;
            $dest     = $uploadDir . $fileName;

            if (move_uploaded_file($tmpName, $dest)) {
                $imageUrl = $uploadUrlBase . $fileName;
                mysqli_query(
                    $con,
                    "INSERT INTO `product_images`(`url`, `product_id`) 
                     VALUES ('$imageUrl','$product_id')"
                );
            }
        }
    }

    return success($lang === 'en' ? 'Product added successfully' : "تمت اضافة المنتج بنجاح");
}
