<?php
header('Content-Type: application/json; charset=utf-8');

require "../../connect.php";
require "../../helpers/jwt.php";

// Authorize user (depending on your jwt.php implementation)
$user = getAuthorizedUser();

if ($_SERVER["REQUEST_METHOD"] !== 'POST') {
    http_response_code(405);
    echo json_encode(['message' => 'Method Not Allowed']);
    exit;
}

// Read JSON body
$json    = file_get_contents('php://input');
$request = json_decode($json, true);

// Validate product_id
if (!is_array($request) || !isset($request['product_id'])) {
    http_response_code(400);
    echo json_encode(['message' => 'product_id is required']);
    exit;
}

$product_id_raw = $request['product_id'];

if (!ctype_digit((string)$product_id_raw)) {
    http_response_code(400);
    echo json_encode(['message' => 'Invalid product_id']);
    exit;
}

$product_id = (int)$product_id_raw;

/* =======================
   CHECK PRODUCT EXISTS
   ======================= */

$sql    = "SELECT product_id FROM `products` WHERE product_id = $product_id LIMIT 1";
$result = mysqli_query($con, $sql);

if (!$result || mysqli_num_rows($result) === 0) {
    http_response_code(404);
    echo json_encode(['message' => 'Product not found']);
    exit;
}

/* =======================
   DELETE RELATED DATA (OPTIONAL)
   If you have product_images table, delete linked images first
   ======================= */

$delete_images_sql = "DELETE FROM `product_images` WHERE product_id = $product_id";
mysqli_query($con, $delete_images_sql); // no need to check, optional

/* =======================
   HARD DELETE PRODUCT
   ======================= */

$delete_sql = "DELETE FROM `products` WHERE product_id = $product_id LIMIT 1";
$delete     = mysqli_query($con, $delete_sql);

if ($delete && mysqli_affected_rows($con) > 0) {
    http_response_code(200);
    echo json_encode([
        "status"=>"success",
        'message' => 'Product deleted successfully',
    ]);
} else {
    // Query failed or no rows affected for some reason
    http_response_code(500);
    echo json_encode(['message' => 'Failed to delete product']);
}
