<?php

require "../../connect.php";
require "../../helpers/jwt.php";

header('Content-Type: application/json');
$user = getAuthorizedUser();


if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit(json_encode(['message' => 'Method Not Allowed']));
}


$page     = isset($_GET['page'])     ? max(1, (int)$_GET['page'])             : 1;
$per_page = isset($_GET['per_page']) ? min(100, max(1, (int)$_GET['per_page'])) : 10;
$offset   = ($page - 1) * $per_page;


$countSql = "SELECT COUNT(*) AS total FROM `user_reports`";
$countRes = $con->query($countSql);
if (!$countRes) {
    http_response_code(500);
    exit(json_encode([
        'error'   => 'Count query failed',
        'details' => $con->error,
    ], JSON_UNESCAPED_UNICODE));
}
$total       = (int)$countRes->fetch_assoc()['total'];
$total_pages = (int)ceil($total / $per_page);


$sql    = "SELECT user_reports.*, JSON_OBJECT('name', uF.user_name, 'email', uF.user_email, 'phone', uF.user_phone) AS fromUser, JSON_OBJECT('name', uR.user_name, 'email', uR.user_email, 'phone', uR.user_phone) AS reportedUser FROM `user_reports` LEFT JOIN users uF ON uF.user_id = user_reports.user_id LEFT JOIN users uR ON uR.user_id = user_reports.user_id LIMIT {$offset}, {$per_page}";
$result = $con->query($sql);
if (!$result) {
    http_response_code(500);
    exit(json_encode([
        'error'   => 'user reports query failed',
        'details' => $con->error,
    ], JSON_UNESCAPED_UNICODE));
}


$user_reports = [];
while ($row = $result->fetch_assoc()) {
    $row['fromUser'] = json_decode($row['fromUser']);
    $row['reportedUser'] = json_decode($row['reportedUser']);
    $user_reports[] = $row;
}


http_response_code(200);
echo json_encode([
    'data' => $user_reports,
    'meta' => [
        'total'        => $total,
        'per_page'     => $per_page,
        'current_page' => $page,
        'total_pages'  => $total_pages,
        'next_page'    => $page < $total_pages ? "?page=" . ($page + 1) . "&per_page={$per_page}" : null,
        'prev_page'    => $page > 1             ? "?page=" . ($page - 1) . "&per_page={$per_page}" : null,
    ],
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

$con->close();
