<?php
// Timezone
date_default_timezone_set('Africa/Cairo');

// ===== CORS HEADERS =====
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization, lang");

// Handle preflight OPTIONS request and stop here
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$requestMethod = $_SERVER['REQUEST_METHOD'];

// ===== DB CONNECTION (MySQLi) =====
$DB_HOST = "localhost";
$DB_USER = "tiffanyf_admin_tiffany";
$DB_PASS = "admin_tiffany";
$DB_NAME = "tiffanyf_tiffany";

// Turn on mysqli errors as exceptions (helpful while debugging)
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

try {
    $con = mysqli_connect($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
    mysqli_set_charset($con, "utf8mb4");
} catch (mysqli_sql_exception $e) {
    // If connection fails, return a clean JSON error and stop
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database connection failed',
        'error'   => $e->getMessage(), // remove this in production if you don’t want to expose details
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

// DO NOT print_r($con); because it breaks your JSON API output
// print_r($con);

// Include shared functions AFTER connection is ready
include "functions.php";
