<?php

// define("MB", 1048576);

function filterRequest($requestname)
{
  return  htmlspecialchars(strip_tags($_POST[$requestname]));
}

function uploadFile($imageRequest) {
    global $errorMsg;
    $errorMsg = []; // Make sure it's initialized

    // Check if file was uploaded
    if (!isset($_FILES[$imageRequest]) || $_FILES[$imageRequest]['error'] !== UPLOAD_ERR_OK) {
        $errorMsg[] = "No file uploaded or upload error.";
        return 'fail';
    }

    $imageName = $_FILES[$imageRequest]['name'];
    $imageTmp  = $_FILES[$imageRequest]['tmp_name'];
    $imageSize = $_FILES[$imageRequest]['size'];

    // === 1. Define upload directory (ABSOLUTE PATH!) ===
    $target_dir = __DIR__ . "/images"; // Critical: use absolute path
    if (!is_dir($target_dir)) {
        mkdir($target_dir, 0755, true); // Create if not exists
    }

    // === 2. Validate file extension ===
    $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'];
    $ext = strtolower(pathinfo($imageName, PATHINFO_EXTENSION));

    if (!in_array($ext, $allowed)) {
        $errorMsg[] = "File type not allowed. Allowed: " . implode(', ', $allowed);
        return 'fail';
    }

    // === 3. Validate file size (2MB = 2 * 1024 * 1024) ===
    if ($imageSize > 2 * 1024 * 1024) {
        $errorMsg[] = "Image must be less than 2MB";
        return 'fail';
    }

    // === 4. Generate safe, unique filename ===
    $newFileName = uniqid('img_', true) . '_' . time() . '.' . $ext;
    $target_file = $target_dir . "/" . $newFileName;

    // === 5. Move the file + CHECK IF SUCCESSFUL ===
    if (move_uploaded_file($imageTmp, $target_file)) {
        // Success: return full public URL
        $domain_name = "https://api.tiffanyflowers.ae/";
        $item_img_url = $domain_name . "images/" . $newFileName;
        return $item_img_url;
    } else {
        // Critical: Log why it failed
        $errorMsg[] = "Failed to move uploaded file. Check folder permissions!";
        error_log("Upload failed: cannot move $imageTmp to $target_file");
        error_log("Directory writable? " . (is_writable($target_dir) ? 'Yes' : 'No'));
        return 'fail';
    }
}


function deleteFile($dir, $imagename)
{
  if (file_exists($dir . "/" . $imagename)) {
    unlink($dir . "/" . $imagename);
  }
}

function checkAuthenticate()
{
  if (isset($_SERVER['PHP_AUTH_USER'])  && isset($_SERVER['PHP_AUTH_PW'])) {
    if ($_SERVER['PHP_AUTH_USER'] != "mohamed roshdy" ||  $_SERVER['PHP_AUTH_PW'] != "123456") {
      header('WWW-Authenticate: Basic realm="My Realm"');
      header('HTTP/1.0 401 Unauthorized');
      echo 'Page Not Found';
      exit;
    }
  } else {
    exit;
  }
}

function printFailure($failMessage)
{
  echo json_encode(
    array(
      "status" => 0,
      "message" => $failMessage
    )
  );
}

function printSuccess($successMessage, $data)
{
  if (empty($data)) {
    echo json_encode(array("status" => 1, "message" => $successMessage));
  } else {
    echo json_encode(array("status" => 1, "message" => $successMessage, "data" => $data));
  }
}

function sendMail($to, $title, $body)
{
  $header = "From: support@tiffanyflowers.com" . "/n" . "CC:mmoh33650@gmail.com";
  mail($to, $title, $body, $header);
}

function error405($requestMethod)
{
     global $current_language;
    
    $response['status'] = "error";
    $response['message'] = sprintf(__('method_not_allowed', $current_language), $method);
    
    return json_encode($response);
//   $response = new stdClass();
//   $response->status = "error";
//   $response->message = $requestMethod . " Method Not Allowed";
//   return json_encode($response);
  exit();
}

function serverError()
{
    global $current_language;
    
    $response['status'] = "error";
    $response['message'] = __('server_error', $current_language);
    // print_r($current_language);
    return json_encode($response);
//   $response = new stdClass();
//   $response->status = "error";
//   $response->message = "Internal Server Error";
//   return json_encode($response);
  exit();
}

function error($errorMessage)
{
    global $current_language;
    
    // Translate the message if it's a translation key
    // $translated_message = __($message, $current_language);
    
    $response['status'] = "error";
    $response['message'] = $errorMessage;
    
    return json_encode($response);
//   $response = new stdClass();
//   $response->status = "error";
//   $response->message = $errorMessage;
//   return json_encode($response);
  exit();
}

function success($success_data)
{
  $response = new stdClass();
  $response->status = "success";
  $response->message = $success_data;
  return json_encode($response);
  exit();
}



function emptyList()
{
  $response = new stdClass();
  $response->status = "success";
  $response->message = array();
  return json_encode($response);
  exit();
}

function assoc_indexed_arr_diff($indexed_array, $assoc_Array, $assocKey)
{
  $array2 = array_column($assoc_Array, $assocKey);

  $missingValues = array_diff($indexed_array, $array2);

  return $missingValues;
}


function get_current_language(){
    $headers = apache_request_headers();
$lang = '';
foreach ($headers as $header => $value) {
    if($header == "lang"){
       $lang = $value;
       break;
    }
}

return $lang;
}

// try{
  // }catch (Exception $e){
                //     echo $e->getMessage();
                // }