<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require "../connect.php";

if ($requestMethod == "POST") {
try {
    $res = addProduct(); // Attempt to call the addProduct() function
    echo $res; // Output the result if successful
} catch (Throwable $e) { // Catch any Throwable (errors or exceptions)
    echo json_encode(['error' => $e->getMessage()]); // Encode the error message as JSON
}
} else {
    echo error405($requestMethod);
}

function addProduct()
{
    global $con;
    $headers = array_change_key_case(getallheaders(), CASE_LOWER);
     $lang = strtolower(trim($headers['lang'] ?? ''));

    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);

    if (!isset($obj['product_name'])) {
        return error($lang == 'en' ? 'Enter product name in Arabic' : 'ادخل اسم المنتج بالعربي');
    }
    if (!isset($obj['product_name_en'])) {
        return error($lang == 'en' ? 'Enter product name in English' : 'ادخل اسم المنتج بالانجليزية');
    }
    if (!isset($obj['product_description'])) {
        return error($lang == 'en' ? 'Enter product description' : 'ادخل وصف المنتج');
    }
    // if (!isset($obj['product_description_en'])) {
    //     return error($lang == 'en' ? 'Enter product description in English' : 'ادخل وصف المنتج بالانجليزية');
    // }
    if (!isset($obj['images'])) {
        return error($lang == 'en' ? 'Enter product images' : 'ادخل صور المنتج');
    }
    if (!isset($obj['price_type'])) {
        return error($lang == 'en' ? 'Enter price type' : 'ادخل نوع السعر')
        ;
    }
    // if (!isset($obj['product_price'])) {
    //     return error($lang == 'en' ? 'Enter product price' : 'ادخل سعر المنتج');
    // }
    // if (!isset($obj['product_discount'])) {
    //     return error($lang == 'en' ? 'Enter product discount' : 'ادخل خصم المنتج');
    // }
    if (!isset($obj['product_url'])) {
        return error($lang == 'en' ? 'Enter product URL' : 'ادخل رابط المنتج');
    }
    if (!isset($obj['product_image'])) {
        return error($lang == 'en' ? 'Enter main product image' : 'ادخل الصورة الرئيسية للمنتج');
    }
    if (!isset($obj['cat_id'])) {
        return error($lang == 'en' ? 'Enter category ID' : 'ادخل معرف القسم');
    }
    if (!isset($obj['seller_id'])) {
        return error($lang == 'en' ? 'Enter seller ID' : 'ادخل معرف البائع');
    }
    // if (!isset($obj['sub_cat_id'])) {
    //     return error($lang == 'en' ? 'Enter sub-category ID' : 'ادخل معرف القسم الفرعي');
    // }
    // if (!isset($obj['product_props'])) {
    //     return error($lang == 'en' ? 'Enter product properties' : 'ادخل خصائص المنتج');
    // }
    if (!isset($obj['location_id'])) {
        return error($lang == 'en' ? 'Enter location ID' : 'ادخل معرف الموقع');
    }
    // if (!isset($obj['price_type'])) {
    //     return error($lang == 'en' ? 'Enter price type' : 'ادخل نوع السعر');
    // }


    $images = mysqli_real_escape_string($con, $obj['images']);
    $product_name = mysqli_real_escape_string($con, $obj['product_name']);
    $product_name_en = mysqli_real_escape_string($con, $obj['product_name_en']);
    $product_description = mysqli_real_escape_string($con, $obj['product_description']);
    $product_description_en = mysqli_real_escape_string($con, $obj['product_description_en']);
    // $product_price = mysqli_real_escape_string($con, $obj['product_price']);
    // $product_discount = mysqli_real_escape_string($con, $obj['product_discount']);
    $product_url = mysqli_real_escape_string($con, $obj['product_url']);
    $product_image = mysqli_real_escape_string($con, $obj['product_image']);
    // $product_props = mysqli_real_escape_string($con, $obj['product_props']); //title*Arazon*value**Arazon**title*Arazon*value
    $seller_id = mysqli_real_escape_string($con, $obj['seller_id']);
    $cat_id = mysqli_real_escape_string($con, $obj['cat_id']);    //2,3,4
    // $sub_cat_id = mysqli_real_escape_string($con, $obj['sub_cat_id']);
    $location_id = mysqli_real_escape_string($con, $obj['location_id']);
    $address_id = mysqli_real_escape_string($con, $obj['address_id']);
    $price_type = mysqli_real_escape_string($con, $obj['price_type']);
    // $ad_pay_image = mysqli_real_escape_string($con, $obj['ad_pay_image']);
    // if (isset($obj['package_id'])) {
    //     $package_id = mysqli_real_escape_string($con, $obj['package_id']);
    //     $ad_payment_id = mysqli_real_escape_string($con, $obj['ad_payment_id']);
    // }else{
    //     $package_id = NULL;
    //     $ad_payment_id = NULL;
    // }


    if (empty(trim($obj['product_name']))) {
        return error($lang == 'en'? 'Enter product name in arabic' : 'ادخل اسم المنتج بالعربي');
    }
    if (empty(trim($obj['product_name_en']))) {
        return error($lang == 'en'? 'Enter product name in english' : 'ادخل اسم المنتج بالانجليزي');
    }
    if (empty(trim($obj['product_description']))) {
        return error($lang == 'en'? 'Enter product description in english' : 'ادخل وصف المنتج بالعربي');
    }
    if (empty(trim($obj['product_description_en']))) {
        return error($lang == 'en'? 'Enter product description in english' : 'ادخل وصف المنتج بالانجليزي');
    }
    // if (empty(trim($obj['product_price']))) {
    //     return error($lang == 'en'? 'Enter product price' : 'ادخل سعر المنتج');
    // }
    if (empty(trim($obj['images']))) {
        return error($lang == 'en'? 'Enter product images' : 'ادخل صور المنتج');
    }
    if (empty(trim($obj['product_image']))) {
        return error($lang == 'en'? 'Enter product main image' : 'ادخل صورة المنتج الرئيسية في المتجر');
    }
    if (empty(trim($obj['seller_id']))) {
        return error($lang == 'en'? 'Enter product seller id' : 'ادخل معرف البائع التابع اليه المنتج');
    }
    if (empty(trim($obj['cat_id']))) {
        return error($lang == 'en'? 'Enter product categories ids' : 'ادخل معرفات الأقسام التابع اليها المنتج');
    }
    // if (empty(trim($obj['sub_cat_id']))) {
    //     return error('ادخل معرف القسم الفرعي التابع اليه المنتج');
    // }
    if (empty(trim($obj['location_id']))) {
        return error($lang == 'en'? 'Enter product location id' : 'ادخل معرف المكان التابع اليه المنتج');
    }
    if (empty(trim($obj['price_type']))) {
        return error($lang == 'en'? 'Enter product price type' : 'ادخل نوع سعر المنتج');
    }
    if($price_type == "free" ){
        $product_price = 0.0;
    }else{
        if (!isset($obj['product_price'])) {
            return error($lang == 'en' ? 'Enter product price' : 'ادخل سعر المنتج');
        }
        $product_price = mysqli_real_escape_string($con, $obj['product_price']);
    }

    $sql_select = mysqli_query($con, "SELECT * FROM `users` WHERE `user_id` = '$seller_id' ");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error($lang == 'en'? 'this seller not exists' : 'هذا التاجر غير موجود');
    }
    
    $row_data = mysqli_fetch_object($sql_select);

    if($row_data->ban == 1){
        return error($lang == 'en'? 'This account is banned' : "هذا الحساب محظور");
    }
    
     $sql_select = mysqli_query($con, "SELECT * FROM `locations` WHERE `location_id` = '$location_id' ");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error($lang == 'en'? 'this location doesnt exist' : 'هذا المكان غير موجود');
    }
    
    if(!empty(trim($obj['address_id']))){
    $sql_select = mysqli_query($con, "SELECT * FROM `addresses` WHERE `address_id` = '$address_id' And `user_id` = '$seller_id' ");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error($lang == 'en'? 'this address doesnt exist' : 'هذا العنوان غير موجود');
    }
    }
    
    // if (isset($obj['package_id'])) {
    //     $package_id = mysqli_real_escape_string($con, $obj['package_id']);
    //     $ad_payment_id = mysqli_real_escape_string($con, $obj['ad_payment_id']);
    // }else{
    //     $package_id = NULL;
    //     $ad_payment_id = NULL;
    // }
    
    if (isset($obj['package_id']) && !empty(trim($obj['package_id']))) {
        $package_id = mysqli_real_escape_string($con, $obj['package_id']);

        if (!isset($obj['ad_payment_id']) || empty(trim($obj['ad_payment_id']))) {
            return error($lang == 'en' ? 'Enter ad payment ID' : 'ادخل معرف دفع الإعلان');
        }

        $ad_payment_id = mysqli_real_escape_string($con, $obj['ad_payment_id']);

        $sql_select = mysqli_query($con, "SELECT * FROM `packages` WHERE `package_id` = '$package_id'");

        if ($sql_select && mysqli_num_rows($sql_select) < 1) {
            return error($lang == 'en' ? 'This package doesn’t exist' : 'هذة الباقة غير موجودة');
        }
    } else {
        $package_id = NULL;
        $ad_payment_id = NULL;
    }

    $cats = explode(",",$cat_id);
    foreach($cats as $cat){
        $sql_select = mysqli_query($con, "SELECT * FROM `categories` WHERE `cat_id` = '$cat' AND `hidden` = '0' ");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error($lang == 'en'? 'this category ' . $cat->id . ' doesnt exist' : 'هذا القسم ' . $cat->id . ' غير موجود');
    }
    }
    

    // $sql_select = mysqli_query($con, "SELECT * FROM `categories` WHERE `cat_id` = '$sub_cat_id' AND `parent_id` = '$cat_id' ");
    // if ($sql_select && mysqli_num_rows($sql_select) < 1) {
    //     return error('هذا القسم الفرعي غير موجود او غير تابع للقسم الرئيسي');
    // }

    // if ($product_discount > $product_price) {
    //     return error($lang == 'en'? 'discount must be less than or equel product price' : 'الخصم يجب أن يكون اقل من او يساوي سعر المنتج');
    // }

// if(isset($obj['package_id']) && !empty(trim($obj['package_id']))){
    $sql_select = mysqli_query($con, "INSERT INTO `products`(`product_name`,`product_name_en`,`product_description`,`product_description_en`,`product_price`, `product_url`,`product_image`, `product_catId`, `seller_id`, `location_id`, `address_id`, `package_id`,`price_type`, `ad_payment_id`) VALUES ('$product_name','$product_name_en','$product_description','$product_description_en','$product_price', '$product_url','$product_image','$cat_id','$seller_id', '$location_id', '$address_id','$package_id','$price_type', '$ad_payment_id')");
    // }else{
            // $sql_select = mysqli_query($con, "INSERT INTO `products`(`product_name`,`product_name_en`,`product_description`,`product_description_en`,`product_price`, `product_discount`, `product_url`,`product_image`, `product_catId`, `seller_id`, `location_id`, `address_id`,`price_type`,`ad_pay_image`) VALUES ('$product_name','$product_name_en','$product_description','$product_description_en','$product_price','$product_discount', '$product_url','$product_image','$cat_id','$seller_id', '$location_id', '$address_id','$price_type', '$ad_pay_image')");
    // }
    if ($sql_select) {

        $product_id = mysqli_insert_id($con);

        // if ($product_props != null || $product_props != '') {
        //     $props =  explode('**Arazon**', $product_props);

        //     for ($i = 0; $i < count($props); $i++) {
        //         $prop = $props[$i];
        //         $prop_title = explode("*Arazon*", $prop)[0];
        //         $prop_value = explode("*Arazon*", $prop)[1];

        //         $sql_select = mysqli_query($con, "INSERT INTO `product_props`(`title`, `value`,`product_id`) VALUES ('$prop_title','$prop_value','$product_id')");
        //     }
        // }

        if ($images != null || $images != '') {
            $images = explode("*Arazon*", $images);

            for ($i = 0; $i < count($images); $i++) {
                $image = $images[$i];
                $sql_select = mysqli_query($con, "INSERT INTO `product_images`(`url`, `product_id`) VALUES ('$image','$product_id')");
            }
        }
        
        $sql_count = mysqli_query($con, "SELECT COUNT(*) AS total_products FROM `products` WHERE seller_id = '$seller_id' ");
        $sql_fetch = mysqli_fetch_assoc($sql_count);
        
        if($sql_fetch['total_products'] > 10){
             mysqli_query($con, "UPDATE `users` SET user_type = '2' WHERE user_id = '$seller_id'");
        }
        

        return success($lang == 'en'? 'product added successfully' : "تمت اضافة المنتج بنجاح");
    } else {
        return serverError();
    }
}
