<?php
// require_once "../connect.php";
// require "../lang.php";

// header('Content-Type: application/json; charset=utf-8');
// ini_set('display_errors', false);
// ini_set('log_errors', true);
// ini_set('error_log', __DIR__ . '/error.log');

// // Start timing
// $start_time = microtime(true);

// if (!$con) {
//     error_log('Database connection failed: ' . mysqli_connect_error());
//     http_response_code(500);
//     echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
//     exit;
// }
// $lang = get_current_language();

// // Get parameters
// $search = trim($_GET['search'] ?? '');
// $category_id = $_GET['category_id'] ?? '';
// $location_id = $_GET['location_id'] ?? '';
// $from_price = $_GET['from_price'] ?? '';
// $to_price = $_GET['to_price'] ?? '';
// $order = (int)($_GET['order'] ?? 1);
// $user_id = (int)($_GET['user_id'] ?? 0);
// $limit = min((int)($_GET['limit'] ?? 5), 50);

// // Initialize variables
// $keywords = [];
// $split_keywords = [];
// $query_embedding = [];
// $bind_types = "i";
// $bind_values = [$user_id];

// // Cache directory
// $cache_dir = __DIR__ . '/cache';
// if (!is_dir($cache_dir)) {
//     mkdir($cache_dir, 0755, true);
// }

// if (!empty($search)) {
//     // Check if embedding column exists
//     $check_column = $con->query("SHOW COLUMNS FROM products LIKE 'embedding'");
//     if ($check_column->num_rows === 0) {
//         error_log('Embedding column missing in products table');
//         http_response_code(500);
//         echo json_encode(['status' => 'error', 'message' => 'Embedding column missing']);
//         exit;
//     }

//     $api_key = 'sk-proj-iDw4Lwlzq8CU2hiFP0onlzQJCt40PQ10BzCTdJcriwAKIEN1D8vWp9D8qOpZDJalb37ErY8JtZT3BlbkFJ_CC4VnhxjNGYSD18gs5rPeTx-0KGE_xLRmpfyWJ8QJ81JsSGbZJh5zLbREwpvRmLYQcTjioA'; // Replace with new key if invalid
//     $lang = get_current_language();

//     // Cosine similarity function
//     function cosineSimilarity($vecA, $vecB) {
//         if (count($vecA) !== count($vecB) || empty($vecA) || empty($vecB)) {
//             error_log('Cosine similarity error: Vector lengths - A: ' . count($vecA) . ', B: ' . count($vecB));
//             return 0;
//         }
//         $dotProduct = 0.0;
//         $normA = 0.0;
//         $normB = 0.0;
//         for ($i = 0; $i < count($vecA); $i++) {
//             $dotProduct += $vecA[$i] * $vecB[$i];
//             $normA += $vecA[$i] * $vecA[$i];
//             $normB += $vecB[$i] * $vecB[$i];
//         }
//         $normA = sqrt($normA);
//         $normB = sqrt($normB);
//         return ($normA * $normB == 0) ? 0 : $dotProduct / ($normA * $normB);
//     }

//     // Get keywords from ChatGPT
//     $cache_key = md5($search);
//     $keyword_cache_file = $cache_dir . '/' . $cache_key . '_keywords.json';

//     if (file_exists($keyword_cache_file) && (time() - filemtime($keyword_cache_file)) < 3600) {
//         $keywords = json_decode(file_get_contents($keyword_cache_file), true);
//         error_log('Using cached keywords for query: ' . $search);
//     } else {
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, 'https://api.openai.com/v1/chat/completions');
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
//         curl_setopt($ch, CURLOPT_POST, 1);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, [
//             'Authorization: Bearer ' . $api_key,
//             'Content-Type: application/json'
//         ]);
//         curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
//             'model' => 'gpt-3.5-turbo',
//             'messages' => [
//                 [
//                     'role' => 'user',
//                     'content' => 'Given the search query "' . $search . '", return a JSON array of relevant keywords or a category name that best describes the product type. Focus on product categories or descriptive terms suitable for an e-commerce platform. For example, for "المي", return ["water", "waterproof", "water-resistant"] or "Waterproof Products". Respond only with the JSON array or string.'
//                 ]
//             ],
//             'max_tokens' => 50
//         ]));
//         curl_setopt($ch, CURLOPT_TIMEOUT, 6);

//         $keyword_response = curl_exec($ch);
//         $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
//         $curl_error = curl_error($ch);
//         curl_close($ch);

//         if ($http_code === 200 && !$curl_error) {
//             $keyword_data = json_decode($keyword_response, true);
//             if (isset($keyword_data['choices'][0]['message']['content'])) {
//                 $keywords = json_decode($keyword_data['choices'][0]['message']['content'], true);
//                 if (!is_array($keywords)) {
//                     $keywords = [$keywords];
//                 }
//                 file_put_contents($keyword_cache_file, json_encode($keywords));
//                 error_log('Keywords for query "' . $search . '": ' . json_encode($keywords));
//             } else {
//                 $keywords = [$search];
//                 error_log('Invalid ChatGPT response for keywords');
//             }
//         } else {
//             error_log('ChatGPT API error: HTTP ' . $http_code . ', cURL error: ' . $curl_error);
//             $keywords = [$search]; // Fallback to search term
//         }
//     }

//     // Split keywords into individual terms
//     foreach ($keywords as $keyword) {
//         $terms = preg_split('/\s+/', strtolower(trim($keyword)));
//         $split_keywords = array_merge($split_keywords, $terms);
//     }
//     $split_keywords = array_unique($split_keywords);

//     // Cache query embedding
//     $cache_file = $cache_dir . '/' . $cache_key . '.json';
//     if (file_exists($cache_file) && (time() - filemtime($cache_file)) < 3600) {
//         $query_embedding = json_decode(file_get_contents($cache_file), true);
//         error_log('Using cached embedding for query: ' . $search);
//     } else {
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, 'https://api.openai.com/v1/embeddings');
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
//         curl_setopt($ch, CURLOPT_POST, 1);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, [
//             'Authorization: Bearer ' . $api_key,
//             'Content-Type: application/json'
//         ]);
//         curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
//             'model' => 'text-embedding-ada-002',
//             'input' => $search
//         ]));
//         curl_setopt($ch, CURLOPT_TIMEOUT, 6);

//         $response = curl_exec($ch);
//         $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
//         $curl_error = curl_error($ch);
//         curl_close($ch);

//         if ($http_code === 200 && !$curl_error) {
//             $response_data = json_decode($response, true);
//             if (isset($response_data['data'][0]['embedding'])) {
//                 $query_embedding = $response_data['data'][0]['embedding'];
//                 file_put_contents($cache_file, json_encode($query_embedding));
//             } else {
//                 error_log('Invalid OpenAI embedding response: ' . json_last_error_msg());
//                 $query_embedding = []; // Fallback to no embedding
//             }
//         } else {
//             error_log('Embedding API error: HTTP ' . $http_code . ', cURL error: ' . $curl_error);
//             $query_embedding = []; // Fallback to no embedding
//         }
//     }
// }

// // Build SQL query
// $sql = "SELECT p.*, 
//         CASE WHEN f.favorite_id IS NOT NULL THEN 1 ELSE 0 END as is_favorite,
//         CASE WHEN c.item_id IS NOT NULL THEN 1 ELSE 0 END as in_cart,
//         (
//             SELECT JSON_ARRAYAGG(pi.url)
//             FROM product_images pi
//             WHERE pi.product_id = p.product_id
//         ) as images,
//         p.embedding
//         FROM products p
//         LEFT JOIN cart c ON c.item_productId = p.product_id
//         LEFT JOIN favorites f ON p.product_id = f.favorite_productId AND f.favorite_userId = ?
//         WHERE p.hidden = '0'";

// // Keyword filter
// $keyword_filter = '';
// if (!empty($split_keywords)) {
//     $keyword_conditions = [];
//     foreach ($split_keywords as $keyword) {
//         $keyword = $con->real_escape_string($keyword);
//         $keyword_conditions[] = "LOWER(p.product_name) LIKE '%$keyword%' OR LOWER(p.product_name_en) LIKE '%$keyword%' OR LOWER(p.product_description) LIKE '%$keyword%' OR LOWER(p.product_description_en) LIKE '%$keyword%'";
//     }
//     $keyword_filter = ' AND (' . implode(' OR ', $keyword_conditions) . ')';
// }
// $sql .= $keyword_filter;

// // Additional filters
// if (!empty($category_id)) {
//     $sql .= " AND FIND_IN_SET(?, p.product_catId)";
//     $bind_types .= "s";
//     $bind_values[] = $category_id;
// }
// if (!empty($location_id)) {
//     $sql .= " AND p.location_id = ?";
//     $bind_types .= "i";
//     $bind_values[] = (int)$location_id;
// }
// if ($from_price !== '') {
//     $sql .= " AND p.product_price >= ?";
//     $bind_types .= "d";
//     $bind_values[] = (float)$from_price;
// }
// if ($to_price !== '') {
//     $sql .= " AND p.product_price <= ?";
//     $bind_types .= "d";
//     $bind_values[] = (float)$to_price;
// }

// // Ordering
// switch ($order) {
//     case 2:
//         $sql .= " ORDER BY p.product_price ASC";
//         break;
//     case 3:
//         $sql .= " ORDER BY p.product_price DESC";
//         break;
//     case 1:
//     default:
//         $sql .= " ORDER BY p.created_at DESC";
//         break;
// }

// // Log SQL for debugging
// error_log("Main query SQL: $sql, Bind types: $bind_types, Bind values: " . json_encode($bind_values));

// // Prepare and execute query
// $stmt = $con->prepare($sql);
// if (!$stmt) {
//     error_log('Main query prepare failed: ' . $con->error);
//     http_response_code(500);
//     echo json_encode(['status' => 'error', 'message' => 'Query preparation failed: ' . $con->error]);
//     exit;
// }

// if (!empty($bind_values)) {
//     $stmt->bind_param($bind_types, ...$bind_values);
// }
// $stmt->execute();
// $result = $stmt->get_result();

// $products = [];
// $skipped = 0;
// if (!empty($search) && !empty($query_embedding)) {
//     while ($row = $result->fetch_assoc()) {
//         if (!empty($row['embedding'])) {
//             $embedding = json_decode($row['embedding'], true);
//             if (json_last_error() === JSON_ERROR_NONE && is_array($embedding) && count($embedding) === 1536) {
//                 $similarity = cosineSimilarity($query_embedding, $embedding);
//                 if ($similarity >= 0.4) {
//                     $row['similarity'] = $similarity;
//                     $row['images'] = !empty($row['images']) ? json_decode($row['images'], true) : [];
//                     $row['product_name'] = $lang === 'ar' ? $row['product_name'] : $row['product_name_en'];
//                     $row['product_description'] = $lang === 'ar' ? $row['product_description'] : $row['product_description_en'];
//                     unset($row['product_name_en'], $row['product_description_en'], $row['embedding']);
//                     $products[] = $row;
//                 } else {
//                     error_log('Product ID ' . $row['product_id'] . ' skipped due to low similarity: ' . $similarity);
//                     $skipped++;
//                 }
//             } else {
//                 error_log('Invalid embedding for product ID ' . $row['product_id'] . ': ' . json_last_error_msg());
//                 $skipped++;
//             }
//         } else {
//             error_log('Empty embedding for product ID ' . $row['product_id']);
//             $skipped++;
//         }
//     }
// } else {
//     while ($row = $result->fetch_assoc()) {
//         $row['images'] = !empty($row['images']) ? json_decode($row['images'], true) : [];
//         $row['product_name'] = $lang === 'ar' ? $row['product_name'] : $row['product_name_en'];
//         $row['product_description'] = $lang === 'ar' ? $row['product_description'] : $row['product_description_en'];
//         unset($row['product_name_en'], $row['product_description_en'], $row['embedding']);
//         $products[] = $row;
//     }
// }

// $stmt->close();

// $execution_time = microtime(true) - $start_time;
// error_log("Processed query '$search' in $execution_time seconds, skipped $skipped products");

// // Fallback if no products found
// if (empty($products)) {
//     $sql = "SELECT p.*, 
//     CASE WHEN c.item_id IS NOT NULL THEN 1 ELSE 0 END as in_cart,
//             CASE WHEN f.favorite_id IS NOT NULL THEN 1 ELSE 0 END as is_favorite,
//             (
//                 SELECT JSON_ARRAYAGG(pi.url)
//                 FROM product_images pi
//                 WHERE pi.product_id = p.product_id
//             ) as images,
//             p.embedding
//             FROM products p
//             LEFT JOIN cart c ON c.item_productId = p.product_id
//             LEFT JOIN favorites f ON p.product_id = f.favorite_productId AND f.favorite_userId = ?
//             WHERE p.hidden = '0'";
//     $bind_types = "i";
//     $bind_values = [$user_id];

//     if (!empty($category_id)) {
//         $sql .= " AND FIND_IN_SET(?, p.product_catId)";
//         $bind_types .= "s";
//         $bind_values[] = $category_id;
//     }
//     if (!empty($location_id)) {
//         $sql .= " AND p.location_id = ?";
//         $bind_types .= "i";
//         $bind_values[] = (int)$location_id;
//     }
//     if ($from_price !== '') {
//         $sql .= " AND p.product_price >= ?";
//         $bind_types .= "d";
//         $bind_values[] = (float)$from_price;
//     }
//     if ($to_price !== '') {
//         $sql .= " AND p.product_price <= ?";
//         $bind_types .= "d";
//         $bind_values[] = (float)$to_price;
//     }

//     if (!empty($search) && !empty($query_embedding)) {
//         $sql .= " AND p.embedding IS NOT NULL AND p.embedding != ''";
//     }

//     switch ($order) {
//         case 2:
//             $sql .= " ORDER BY p.product_price ASC";
//             break;
//         case 3:
//             $sql .= " ORDER BY p.product_price DESC";
//             break;
//         case 1:
//         default:
//             $sql .= " ORDER BY p.created_at DESC";
//             break;
//     }

//     // Log fallback SQL
//     error_log("Fallback query SQL: $sql, Bind types: $bind_types, Bind values: " . json_encode($bind_values));

//     $stmt = $con->prepare($sql);
//     if (!$stmt) {
//         error_log('Fallback query prepare failed: ' . $con->error);
//         http_response_code(500);
//         echo json_encode(['status' => 'error', 'message' => 'Fallback query preparation failed: ' . $con->error]);
//         exit;
//     }

//     if (!empty($bind_values)) {
//         $stmt->bind_param($bind_types, ...$bind_values);
//     }
//     $stmt->execute();
//     $result = $stmt->get_result();

//     $products = [];
//     if (!empty($search) && !empty($query_embedding)) {
//         while ($row = $result->fetch_assoc()) {
//             $embedding = json_decode($row['embedding'], true);
//             if (json_last_error() === JSON_ERROR_NONE && is_array($embedding) && count($embedding) === 1536) {
//                 $similarity = cosineSimilarity($query_embedding, $embedding);
//                 if ($similarity >= 0.4) {
//                     $row['similarity'] = $similarity;
//                     $row['images'] = !empty($row['images']) ? json_decode($row['images'], true) : [];
//                     $row['product_name'] = $lang === 'ar' ? $row['product_name'] : $row['product_name_en'];
//                     $row['product_description'] = $lang === 'ar' ? $row['product_description'] : $row['product_description_en'];
//                     unset($row['product_name_en'], $row['product_description_en'], $row['embedding']);
//                     $products[] = $row;
//                 } else {
//                     error_log('Product ID ' . $row['product_id'] . ' skipped due to low similarity: ' . $similarity);
//                     $skipped++;
//                 }
//             } else {
//                 error_log('Invalid embedding for product ID ' . $row['product_id'] . ': ' . json_last_error_msg());
//                 $skipped++;
//             }
//         }
//     } else {
//         while ($row = $result->fetch_assoc()) {
//             $row['images'] = !empty($row['images']) ? json_decode($row['images'], true) : [];
//             $row['product_name'] = $lang === 'ar' ? $row['product_name'] : $row['product_name_en'];
//             $row['product_description'] = $lang === 'ar' ? $row['product_description'] : $row['product_description_en'];
//             unset($row['product_name_en'], $row['product_description_en'], $row['embedding']);
//             $products[] = $row;
//         }
//     }

//     $stmt->close();
// }

// // Close connection
// $con->close();

// // Return response
// if (empty($products)) {
//     echo json_encode([
//         'status' => 'success',
//         'message' => []
//     ]);
// } else {
//     if (!empty($search) && !empty($query_embedding)) {
//         usort($products, function($a, $b) {
//             return $b['similarity'] <=> $a['similarity'];
//         });
//     }
//     $products = array_slice($products, 0, $limit);
//     echo json_encode([
//         'status' => 'success',
//         'message' => $products
//     ]);
// }
?>









<?php
require_once "../connect.php";
require "../lang.php";

header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors', false);
ini_set('log_errors', true);
ini_set('error_log', __DIR__ . '/error.log');

// Polyfill for str_starts_with if running on PHP < 8
if (!function_exists('str_starts_with')) {
    function str_starts_with($haystack, $needle) {
        return $needle !== '' && strncmp($haystack, $needle, strlen($needle)) === 0;
    }
}

// Start timing
$start_time = microtime(true);

if (!$con) {
    error_log('Database connection failed: ' . mysqli_connect_error());
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

$lang = get_current_language();

// Get parameters
$search      = trim($_GET['search'] ?? '');
$category_id = $_GET['category_id'] ?? '';
$location_id = $_GET['location_id'] ?? '';
$from_price  = $_GET['from_price'] ?? '';
$to_price    = $_GET['to_price'] ?? '';
$order       = (int)($_GET['order'] ?? 1);
$user_id     = (int)($_GET['user_id'] ?? 0);
$limit       = min((int)($_GET['limit'] ?? 5), 50);

// Prepare binding
$bind_types  = "i";          // first param is user_id for favorites join
$bind_values = [$user_id];

// Build base SQL query (no AI, no embeddings)
$sql = "SELECT 
            p.*,
            CASE WHEN f.favorite_id IS NOT NULL THEN 1 ELSE 0 END AS is_favorite,
            CASE WHEN c.item_id IS NOT NULL THEN 1 ELSE 0 END AS in_cart,
            (
                SELECT JSON_ARRAYAGG(pi.url)
                FROM product_images pi
                WHERE pi.product_id = p.product_id
            ) AS images
        FROM products p
        LEFT JOIN cart c ON c.item_productId = p.product_id
        LEFT JOIN favorites f ON p.product_id = f.favorite_productId 
            AND f.favorite_userId = ?
        WHERE p.hidden = '0'";

// Build simple keyword search using LIKE on product name / description
if (!empty($search)) {
    $split_keywords = preg_split('/\s+/', mb_strtolower($search));
    $split_keywords = array_unique(array_filter($split_keywords));

    if (!empty($split_keywords)) {
        $keyword_conditions = [];
        foreach ($split_keywords as $keyword) {
            $keyword = $con->real_escape_string($keyword);
            $keyword_conditions[] =
                "LOWER(p.product_name) LIKE '%$keyword%' 
                 OR LOWER(p.product_name_en) LIKE '%$keyword%' 
                 OR LOWER(p.product_description) LIKE '%$keyword%' 
                 OR LOWER(p.product_description_en) LIKE '%$keyword%'";
        }
        $sql .= ' AND (' . implode(' OR ', $keyword_conditions) . ')';
    }
}

// Additional filters
if (!empty($category_id)) {
    $sql          .= " AND FIND_IN_SET(?, p.product_catId)";
    $bind_types   .= "s";
    $bind_values[] = $category_id;
}

if (!empty($location_id)) {
    $sql          .= " AND p.location_id = ?";
    $bind_types   .= "i";
    $bind_values[] = (int)$location_id;
}

if ($from_price !== '') {
    $sql          .= " AND p.product_price >= ?";
    $bind_types   .= "d";
    $bind_values[] = (float)$from_price;
}

if ($to_price !== '') {
    $sql          .= " AND p.product_price <= ?";
    $bind_types   .= "d";
    $bind_values[] = (float)$to_price;
}

// Ordering
switch ($order) {
    case 2:
        $sql .= " ORDER BY p.product_price ASC";
        break;
    case 3:
        $sql .= " ORDER BY p.product_price DESC";
        break;
    case 1:
    default:
        $sql .= " ORDER BY p.created_at DESC";
        break;
}

// Log SQL for debugging
error_log("Main query SQL: $sql, Bind types: $bind_types, Bind values: " . json_encode($bind_values));

// Prepare and execute main query
$stmt = $con->prepare($sql);
if (!$stmt) {
    error_log('Main query prepare failed: ' . $con->error);
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Query preparation failed: ' . $con->error]);
    exit;
}

if (!empty($bind_values)) {
    $stmt->bind_param($bind_types, ...$bind_values);
}

$stmt->execute();
$result = $stmt->get_result();

$products = [];
while ($row = $result->fetch_assoc()) {
    // Decode images JSON array if present
    if (!empty($row['images'])) {
        $imgs = json_decode($row['images'], true);
        if (!is_array($imgs)) {
            $imgs = [];
        }

      
          $properties =  array(["title"=>"Small", "value"=>0]);
                 $product_id = $row['product_id'];
    $sql_props = mysqli_query($con, "
        SELECT * 
        FROM product_props 
        WHERE product_id = '$product_id'
    ");
    if ($sql_props && mysqli_num_rows($sql_props)>0) {
        $properties = [];
        while ($prop = mysqli_fetch_assoc($sql_props)) {
            $properties[] = [
                'id'    => $prop['id']    ?? '',
                'name'  => $prop['title'] ?? '',
                'value' => $prop['value'] ?? '',
            ];
        }
    }
                            $row['properties'] = $properties ; 
 $row['product_colors'] = json_decode($row['product_colors']); 
        foreach ($imgs as $idx => $img) {
            // If JSON_ARRAYAGG(pi.url) → array of strings
            if (is_string($img)) {
                if (!str_starts_with($img, 'http')) {
                    $imgs[$idx] = "https://api.tiffanyflowers.ae/admin/" . ltrim($img, '/');
                }
            }
            // If later you change to JSON_OBJECT('url', pi.url)
            elseif (is_array($img) && isset($img['url']) && is_string($img['url'])) {
                if (!str_starts_with($img['url'], 'http')) {
                    $img['url'] = "https://api.tiffanyflowers.ae/admin/" . ltrim($img['url'], '/');
                }
                $imgs[$idx] = $img;
            }
        }

        $row['images'] = $imgs;
    } else {
        $row['images'] = [];
    }

    // Localize fields
    $row['product_name'] = $lang === 'ar' ? $row['product_name'] : $row['product_name_en'];
    $row['product_description'] = $lang === 'ar' ? $row['product_description'] : $row['product_description_en'];

    unset($row['product_name_en'], $row['product_description_en']);
    $products[] = $row;
}

$stmt->close();

$execution_time = microtime(true) - $start_time;
error_log("Processed query '$search' in $execution_time seconds, found " . count($products) . " products");

// Fallback if no products found: ignore search text, only filters
if (empty($products)) {
    $sql = "SELECT 
                p.*,
                CASE WHEN c.item_id IS NOT NULL THEN 1 ELSE 0 END AS in_cart,
                CASE WHEN f.favorite_id IS NOT NULL THEN 1 ELSE 0 END AS is_favorite,
                (
                    SELECT JSON_ARRAYAGG(pi.url)
                    FROM product_images pi
                    WHERE pi.product_id = p.product_id
                ) AS images
            FROM products p
            LEFT JOIN cart c ON c.item_productId = p.product_id
            LEFT JOIN favorites f ON p.product_id = f.favorite_productId 
                AND f.favorite_userId = ?
            WHERE p.hidden = '0'";

    $bind_types  = "i";
    $bind_values = [$user_id];

    if (!empty($category_id)) {
        $sql          .= " AND FIND_IN_SET(?, p.product_catId)";
        $bind_types   .= "s";
        $bind_values[] = $category_id;
    }

    if (!empty($location_id)) {
        $sql          .= " AND p.location_id = ?";
        $bind_types   .= "i";
        $bind_values[] = (int)$location_id;
    }

    if ($from_price !== '') {
        $sql          .= " AND p.product_price >= ?";
        $bind_types   .= "d";
        $bind_values[] = (float)$from_price;
    }

    if ($to_price !== '') {
        $sql          .= " AND p.product_price <= ?";
        $bind_types   .= "d";
        $bind_values[] = (float)$to_price;
    }

    switch ($order) {
        case 2:
            $sql .= " ORDER BY p.product_price ASC";
            break;
        case 3:
            $sql .= " ORDER BY p.product_price DESC";
            break;
        case 1:
        default:
            $sql .= " ORDER BY p.created_at DESC";
            break;
    }

    error_log("Fallback query SQL: $sql, Bind types: $bind_types, Bind values: " . json_encode($bind_values));

    $stmt = $con->prepare($sql);
    if (!$stmt) {
        error_log('Fallback query prepare failed: ' . $con->error);
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Fallback query preparation failed: ' . $con->error]);
        exit;
    }

    if (!empty($bind_values)) {
        $stmt->bind_param($bind_types, ...$bind_values);
    }

    $stmt->execute();
    $result = $stmt->get_result();

    $products = [];
    while ($row = $result->fetch_assoc()) {
          $properties =  array(["title"=>"Small", "value"=>0]);
                 $product_id = $row['product_id'];
    $sql_props = mysqli_query($con, "
        SELECT * 
        FROM product_props 
        WHERE product_id = '$product_id'
    ");
    if ($sql_props && mysqli_num_rows($sql_props)>0) {
        $properties = [];
        while ($prop = mysqli_fetch_assoc($sql_props)) {
            $properties[] = [
                'id'    => $prop['id']    ?? '',
                'name'  => $prop['title'] ?? '',
                'value' => $prop['value'] ?? '',
            ];
        }
    }
            $row['properties'] = $properties ; 
            $row['product_colors'] = json_decode($row['product_colors']); 
        if (!empty($row['images'])) {
            $imgs = json_decode($row['images'], true);
            if (!is_array($imgs)) {
                $imgs = [];
            }

            foreach ($imgs as $idx => $img) {
                if (is_string($img)) {
                    if (!str_starts_with($img, 'http')) {
                        $imgs[$idx] = "https://api.tiffanyflowers.ae/admin/" . ltrim($img, '/');
                    }
                } elseif (is_array($img) && isset($img['url']) && is_string($img['url'])) {
                    if (!str_starts_with($img['url'], 'http')) {
                        $img['url'] = "https://api.tiffanyflowers.ae/admin/" . ltrim($img['url'], '/');
                    }
                    $imgs[$idx] = $img;
                }
            }

            $row['images'] = $imgs;
        } else {
            $row['images'] = [];
        }
        
        
      
        $row['product_name'] = $lang === 'ar' ? $row['product_name'] : $row['product_name_en'];
        $row['product_description'] = $lang === 'ar' ? $row['product_description'] : $row['product_description_en'];
        unset($row['product_name_en'], $row['product_description_en']);
        $products[] = $row;
    }

    $stmt->close();
}

// Close connection
$con->close();

// Apply limit in PHP (you can also add LIMIT ? in SQL if you prefer)
if (!empty($products)) {
    $products = array_slice($products, 0, $limit);
}

// Return response
echo json_encode([
    'status'  => 'success',
    'message' => $products
], JSON_UNESCAPED_UNICODE);
