<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/../vendor/autoload.php';

header('Content-Type: application/json');

$stripe = new \Stripe\StripeClient('sk_test_51KUaMQHqjMTmDcrpiaM7Pl3inGpggUTqwG2b1dnGuBmsuVPMhc3g0UPnm38WEPTmVXcR4FLlF0afGkj32LV4lyac00OO0CkTcT');

try {
    $customer = $stripe->customers->create();

    $ephemeralKey = $stripe->ephemeralKeys->create([
        'customer' => $customer->id,
    ], [
        'stripe_version' => '2020-08-27',
    ]);

    $paymentIntent = $stripe->paymentIntents->create([
        'amount' => 1099,
        'currency' => 'eur',
        'customer' => $customer->id,
        'automatic_payment_methods' => [
            'enabled' => true,
        ],
    ]);
    echo json_encode([
        'paymentIntent' => $paymentIntent->client_secret,
        'ephemeralKey' => $ephemeralKey->secret,
        'customer' => $customer->id,
        'publishableKey' => 'pk_test_51KUaMQHqjMTmDcrpCEgnTJGjK4XZJgZ3flj7uiuibwP2voCNTSmptTNpzDwBtEf6tSgyP1ZUJNnLmovWOfyh21Ba00hYXTqwzY'
    ]);

    http_response_code(200);

} catch (\Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}