<?php
require "../connect.php";
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$sql = "SELECT * FROM categories WHERE `hidden` = '0'";
$result = mysqli_query($con, $sql);

$headers = array_change_key_case(getallheaders(), CASE_LOWER);
$lang = strtolower(trim($headers['lang'] ?? ''));

if (!$result) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Database query failed',
        'details' => mysqli_error($con)
    ]);
    exit;
}

$all = [];
while ($row = mysqli_fetch_assoc($result)) {
    $row['cat_id']    = (int)$row['cat_id'];
    $row['parent_id'] = (int)$row['parent_id'];
    // $raw->cat_name = $lang == 'en' ? $row['cat_name_en'] : $el['cat_name'];
    $all[] = $row;
}

function buildTree(array $elements, int $parentId = 0,$lang): array {
    $branch = [];
    foreach ($elements as $el) {
        $el['cat_name'] = $lang == 'en' ? $el['cat_name'] : $el['cat_name'];
        if ($el['parent_id'] === $parentId) {
            $children = buildTree($elements, $el['cat_id'],$lang);
            
            $branch[] = [
                'cat_id'   => $el['cat_id'],
                'cat_name' => $el['cat_name'],
                'cat_image' => $el['cat_image'],
                'sub_categories'=> $children
            ];
        }
    }
    return $branch;
}

$tree = buildTree($all, 0,$lang);

$response = new stdClass();
$response->status = "success";
$response->message = $tree;
echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
