<?php

require "../connect.php";
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if ($requestMethod == "POST") {
    $res = addProduct();
    echo $res;
} else {
    echo error405($requestMethod);
}

function addProduct()
{
    global $con;

    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);
    
    if (!isset($obj['product_id'])) {
        return error("enter product_id in row of request body");
    }
    if (!isset($obj['product_name'])) {
        return error("enter product_name in row of request body");
    }
    if (!isset($obj['product_description'])) {
        return error("enter product_description in row of request body");
    }
    if (!isset($obj['images'])) {
        return error("enter images in row of request body");
    }
    if (!isset($obj['product_price'])) {
        return error("enter product_price in row of request body");
    }
    if (!isset($obj['product_discount'])) {
        return error("enter product_discount in row of request body");
    }
    if (!isset($obj['product_url'])) {
        return error("enter product_url in row of request body");
    }
    if (!isset($obj['product_image'])) {
        return error("enter product_image in row of request body");
    }
    if (!isset($obj['cat_id'])) {
        return error("enter cat_id in row of request body");
    }
    if (!isset($obj['seller_id'])) {
        return error("enter seller_id in row of request body");
    }
    // if (!isset($obj['sub_cat_id'])) {
    //     return error("enter cat_id in row of request body");
    // }
    // if (!isset($obj['product_props'])) {
    //     return error("enter product_props in row of request body");
    // }
    if (!isset($obj['location_id'])) {
        return error("enter location_id in row of request body");
    }
    if (!isset($obj['price_type'])) {
        return error("enter price_type in row of request body");
    }

    $product_id = mysqli_real_escape_string($con, $obj['product_id']);
    $images = mysqli_real_escape_string($con, $obj['images']);
    $product_name = mysqli_real_escape_string($con, $obj['product_name']);
    // $product_name_en = mysqli_real_escape_string($con, $obj['product_name_en']);
    $product_description = mysqli_real_escape_string($con, $obj['product_description']);
    // $product_description_en = mysqli_real_escape_string($con, $obj['product_description_en']);
    $product_price = mysqli_real_escape_string($con, $obj['product_price']);
    $product_discount = mysqli_real_escape_string($con, $obj['product_discount']);
    $product_url = mysqli_real_escape_string($con, $obj['product_url']);
    // $product_url_en = mysqli_real_escape_string($con, $obj['product_url_en']);
    $product_image = mysqli_real_escape_string($con, $obj['product_image']);
    // $product_props = mysqli_real_escape_string($con, $obj['product_props']); //title*Arazon*value**Arazon**title*Arazon*value
    $seller_id = mysqli_real_escape_string($con, $obj['seller_id']);
    $cat_id = mysqli_real_escape_string($con, $obj['cat_id']);
    // $sub_cat_id = mysqli_real_escape_string($con, $obj['sub_cat_id']);
    $location_id = mysqli_real_escape_string($con, $obj['location_id']);
    $price_type = mysqli_real_escape_string($con, $obj['price_type']);
    $address_id = mysqli_real_escape_string($con, $obj['address_id']);


    if (empty(trim($obj['product_id']))) {
        return error('ادخل معرف المنتج');
    }
    if (empty(trim($obj['product_name']))) {
        return error('ادخل اسم المنتج');
    }
    if (empty(trim($obj['product_description']))) {
        return error('ادخل وصف المنتج');
    }
    if (empty(trim($obj['product_price']))) {
        return error('ادخل سعر المنتج');
    }
    if (empty(trim($obj['images']))) {
        return error('ادخل صور المنتج');
    }
    if (empty(trim($obj['product_image']))) {
        return error('ادخل عدد المنتج في المتجر');
    }
    if (empty(trim($obj['seller_id']))) {
        return error('ادخل معرف البائع التابع اليه المنتج');
    }
    if (empty(trim($obj['cat_id']))) {
        return error('ادخل معرف القسم الرئيسي التابع اليه المنتج');
    }
    // if (empty(trim($obj['sub_cat_id']))) {
    //     return error('ادخل معرف القسم الفرعي التابع اليه المنتج');
    // }
    if (empty(trim($obj['location_id']))) {
        return error('ادخل معرف المكان التابع اليه المنتج');
    }
    if (empty(trim($obj['price_type']))) {
        return error($lang == 'en'? 'Enter product price type' : 'ادخل نوع سعر المنتج');
    }

$sql_select = mysqli_query($con, "SELECT * FROM `products` WHERE `product_id` = '$product_id' AND `seller_id` = '$seller_id'");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error('هذا المنتج غير متاح');
    }
    $sql_select = mysqli_query($con, "SELECT * FROM `users` WHERE `user_id` = '$seller_id' ");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error('هذا التاجر غير موجود');
    }
    
    $row_data = mysqli_fetch_object($sql_select);

    if($row_data->ban == 1){
        return error("هذا الحساب محظور");
    }
    
     $sql_select = mysqli_query($con, "SELECT * FROM `locations` WHERE `location_id` = '$location_id' ");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error('هذا المكان غير موجود');
    }
    
    $cats = explode(",",$cat_id);
    foreach($cats as $cat){
        $sql_select = mysqli_query($con, "SELECT * FROM `categories` WHERE `cat_id` = '$cat' AND `hidden` = '0' ");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error($lang == 'en'? 'this category ' . $cat->id . ' doesnt exist' : 'هذا القسم ' . $cat->id . ' غير موجود');
    }
    }

    if ($product_discount > $product_price) {
        return error('الخصم يجب أن يكون اقل من او يساوي سعر المنتج');
    }

    $sql_select = mysqli_query($con, "UPDATE `products` SET `product_catId`='$cat_id',`location_id`='$location_id',`address_id`='$address_id',`product_name`='$product_name',`product_name_en`='$product_name',`product_image`='$product_image',`product_description`='$product_description',`product_description_en`='$product_description',`product_price`='$product_price',`price_type`='$price_type',`product_discount`='$product_discount' WHERE `product_id` = '$product_id'");
    if ($sql_select) {

        // $product_id = mysqli_insert_id($con);

        // if ($product_props != null || $product_props != '') {
        //     $props =  explode('**Arazon**', $product_props);

        //     for ($i = 0; $i < count($props); $i++) {
        //         $prop = $props[$i];
        //         $prop_title = explode("*Arazon*", $prop)[0];
        //         $prop_value = explode("*Arazon*", $prop)[1];

        //         $sql_select = mysqli_query($con, "INSERT INTO `product_props`(`title`, `value`,`product_id`) VALUES ('$prop_title','$prop_value','$product_id')");
        //     }
        // }

        if ($images != null || $images != '') {
        
            $sql_select = mysqli_query($con, "DELETE FROM `product_images` WHERE `product_id` = '$product_id'");
            $images = explode("*Arazon*", $images);

            for ($i = 0; $i < count($images); $i++) {
                $image = $images[$i];
                $sql_select = mysqli_query($con, "INSERT INTO `product_images`(`url`, `product_id`) VALUES ('$image','$product_id')");
            }
        }


        return success("تم تعديل المنتج بنجاح");
    } else {
        return serverError();
    }
}
