<?php

require "../../connect.php";

if ($requestMethod == "POST") {
    $res = addDeleteFavorite();
    echo $res;
} else {
    echo error405($requestMethod);
}

function addDeleteFavorite()
{
    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);
    $headers = array_change_key_case(getallheaders(), CASE_LOWER);
    $lang = strtolower(trim($headers['lang'] ?? ''));


    //check params
    if (!isset($obj['product_id'])) {
        return error('product_id is missing in url');
    }
    if (!isset($obj['user_id'])) {
        return error('user_id is missing in url');
    }

    global $con;

    $response = new stdClass();

    $product_id = mysqli_real_escape_string($con, $obj['product_id']);
    $user_id = mysqli_real_escape_string($con, $obj['user_id']);

    // check validation
    if (empty(trim($obj['product_id']))) {
        return error('ادخل معرف المنتج');
    }
    if (empty(trim($obj['user_id']))) {
        return error('ادخل معرف المستخدم');
    }

    //check product
    $sql_select_product = mysqli_query($con, "SELECT * FROM `products` WHERE `product_id` = '$product_id'");
    if (mysqli_num_rows($sql_select_product) != 1) {
        return error("المنتج غير موجود");
    }

    $product = mysqli_fetch_object($sql_select_product);
    if($product->hidden == 1){
        return error("المنتج غير موجود");
    }

    //check user
    $sql_select_user = mysqli_query($con, "SELECT * FROM `users` WHERE `user_id` = '$user_id'");
    if (mysqli_num_rows($sql_select_user) != 1) {
        return error("المستخدم غير موجود");
    }

    

    $sql_select_favorite = mysqli_query($con, "SELECT * FROM `favorites` WHERE `favorite_userId` = '$user_id' AND `favorite_productId` = '$product_id'");

    //check in_favorite
    if (mysqli_num_rows($sql_select_favorite) > 0) {

        $sql_select = mysqli_query($con, "DELETE FROM `favorites` WHERE `favorite_productId` = '$product_id' AND `favorite_userId` = '$user_id'");
        if ($sql_select) {
            return success($lang == 'en' ? "Product deleted from favorites successfully" : "تم حذف المنتج من المفضلة");
        } else {
            return serverError();
        }
    } else {
        $sql_select = mysqli_query($con, "INSERT INTO `favorites`(`favorite_productId`, `favorite_userId`) VALUES ('$product_id','$user_id')");
        if ($sql_select) {
            return success($lang == 'en' ? "Product added to favorites successfully" : "تمت اضافة المنتج الي المفضلة");
        } else {
            return serverError();
        }
    }

    return json_encode($response);
}
