<?php

require "../connect.php";
// require "../lang.php";
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$requestMethod = $_SERVER['REQUEST_METHOD'] ?? 'GET';

if ($requestMethod == "POST") {
    $action = $_GET['action'] ?? 'home_data';
    
    switch ($action) {
        case 'remove_discount':
            $res = removeDiscount();
            break;
        default:
            $res = homeData();
    }
    
    echo $res;
} else {
    echo error405($requestMethod);
}


function removeDiscount()
{
    global $con;

    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);
    
    // Required parameters validation
    if (!isset($obj['product_id'])) {
        return error("product_id is missing");
    }
    
    // Extract and sanitize parameters
    $product_id = mysqli_real_escape_string($con, $obj['product_id']);
    
    // Validate product exists
    $sql_check_product = mysqli_query($con, "SELECT * FROM `products` WHERE `product_id` = '$product_id'");
    if (mysqli_num_rows($sql_check_product) != 1) {
        return error("Product not found");
    }
    
    // Update product to remove discount
    $sql_update = mysqli_query($con, "UPDATE `products` SET `product_discount` = 0 WHERE `product_id` = '$product_id'");
    
    if ($sql_update) {
        $response = new stdClass();
        $response->status = "success";
        $response->message = "Discount removed successfully";
        return json_encode($response);
    } else {
        return serverError();
    }
}

function homeData()
{
    global $con;

    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);
    $headers = array_change_key_case(getallheaders(), CASE_LOWER);
    $lang = strtolower(trim($headers['lang'] ?? ''));
    
    if (!isset($obj['user_id'])) {
        return error("user_id is missing in url");
    }

    $user_id = mysqli_real_escape_string($con, $obj['user_id']);
    if (isset($obj['location_id'])) {
        $location_id = mysqli_real_escape_string($con, $obj['location_id']);
    }

    
    if(!empty(trim($obj['user_id']))){
        $sql_select_item = mysqli_query($con, "SELECT * FROM `users` WHERE `user_id` = '$user_id'");
        if (mysqli_num_rows($sql_select_item) != 1) {
            return error("معرف المستخدم غير موجود");
        }
    }
    
    if (isset($obj['location_id'])) {
        if(!empty(trim($obj['location_id']))){
            $sql_select_item = mysqli_query($con, "SELECT * FROM `locations` WHERE `location_id` = '$location_id'");
            if (mysqli_num_rows($sql_select_item) != 1) {
                return error("معرف المكان غير موجود");
            }
        }
    }

    $home_data = array();

    // categories
    $categories_list = array();

    $sql_select = mysqli_query($con, "SELECT * FROM `categories` WHERE `hidden` = '0' AND `parent_id` = 0");


    if ($sql_select) {
        if (mysqli_num_rows($sql_select) > 0) {
            while ($category_object = mysqli_fetch_object($sql_select)) {
                
                $array_data_sub = array();
                $sql_select_sub = mysqli_query($con, "SELECT * FROM `categories` WHERE `parent_id` = $category_object->cat_id AND `hidden` = '0'");
                while ($row_data_sub = mysqli_fetch_object($sql_select_sub)) {
                    $row_data_sub->cat_name = $lang == 'en' ? $row_data_sub->cat_name : $row_data_sub->cat_name;
                    $array_data_sub[] = $row_data_sub;
                }
                $category_object->sub_categories = $array_data_sub;
                $category_object->cat_name = $lang == 'en' ? $category_object->cat_name : $category_object->cat_name;
                
                unset($category_object->hidden);
                $categories_list[] = $category_object;
            }
            $home_data['categories'] = $categories_list;
        } else {
            $home_data['categories'] = array();
        }
    } else {
        return serverError();
    }
    
    
    // locations
    $locations_list = array();

    $sql_select = mysqli_query($con, "SELECT * FROM `locations` WHERE `hidden` = '0'");

    if ($sql_select) {
        if (mysqli_num_rows($sql_select) > 0) {
            while ($location_object = mysqli_fetch_object($sql_select)) {
                $location_object->location_name = $lang == 'en' ? $location_object->location_name_en : $location_object->location_name;
                unset($location_object->hidden);
                $locations_list[] = $location_object;
            }

            $home_data['locations'] = $locations_list;
        } else {
            $home_data['locations'] = array();
        }
    } else {
        return serverError();
    }

    // Exclude blocked users
    $blocked_ids = [];
    
    $blocked_query = mysqli_query($con, "
        SELECT user_blocked_id as id FROM user_blocks WHERE user_id = '$user_id'
        UNION
        SELECT user_id as id FROM user_blocks WHERE user_blocked_id = '$user_id'
    ");
    
    while ($row = mysqli_fetch_assoc($blocked_query)) {
        $blocked_ids[] = $row['id'];
    }
    
    $blocked_ids_sql = "";
    if (!empty($blocked_ids)) {
        $blocked_ids_sql = " AND `seller_id` NOT IN (" . implode(',', array_map('intval', $blocked_ids)) . ")";
    }


    // gallary
    $products_list = array();
    if(!isset($obj['location_id']) || empty(trim($obj['location_id']))){
        // $sql_select_products = mysqli_query($con, "SELECT * FROM `products` WHERE `in_gallery` = '1' ");
        $sql_select_products = mysqli_query($con, "
            SELECT * FROM `products` 
            WHERE `in_gallery` = '1' 
            $blocked_ids_sql
        ");
    }else{
        // $sql_select_products = mysqli_query($con, "SELECT * FROM `products` WHERE `in_gallery` = '1' AND `location_id` = '$location_id'");
        $sql_select_products = mysqli_query($con, "
            SELECT * FROM `products` 
            WHERE `in_gallery` = '1'
            " . (isset($location_id) ? "AND `location_id` = '$location_id'" : "") . "
            $blocked_ids_sql
        ");
    }
    
    if ($sql_select_products) {
        if (mysqli_num_rows($sql_select_products) > 0){
            while ($row_data = mysqli_fetch_object($sql_select_products)) {
                $row_data->product_name = $lang == 'en' ? $row_data->product_name_en : $row_data->product_name;
                $row_data->product_description = $lang == 'en' ? $row_data->product_description_en : $row_data->product_description;
                
                // ADD FULL URL FOR IMAGE (gallery)
                if (!empty($row_data->product_image) && strpos($row_data->product_image, 'http') !== 0) {
                    $row_data->product_image = "https://api.tiffanyflowers.ae/admin/" . ltrim($row_data->product_image, '/');
                }
                
                // Hide discount information
                $row_data->old_price = $row_data->product_price * 1;
                $row_data->new_price = $row_data->product_price;
                
                if(!empty(trim($obj['user_id']))){
                    $sql_select_favorite = mysqli_query($con, "SELECT * FROM `favorites` WHERE `favorite_userId` = '$user_id' AND `favorite_productId` = '$row_data->product_id'");
                    if (mysqli_num_rows($sql_select_favorite) > 0) {
                        $row_data->in_favorite = true;
                    } else {
                        $row_data->in_favorite = false;
                    }

                    $sql_select_cart = mysqli_query($con, "SELECT * FROM `cart` WHERE `item_userId` = '$user_id' AND `item_productId` = '$row_data->product_id'");
                    if (mysqli_num_rows($sql_select_cart) > 0) {
                        $row_data->in_cart = true;
                    } else {
                        $row_data->in_cart = false;
                    }
                }else{
                    $row_data->in_favorite = false;
                    $row_data->in_cart = false;
                }
                unset(
                    $row_data->hidden, 
                    $row_data->product_rejectImage, 
                    $row_data->product_rejectReason, 
                    $row_data->product_status,
                    $row_data->product_discount,
                    $row_data->product_price,
                    $row_data->discount_percentage
                );
                $products_list[] = $row_data;
            }
            $home_data['gallary_products'] = $products_list;
        }else {
            $home_data['gallary_products'] = array();
        }
    }
    else {
        return serverError();
    }


    // recommendations
    $recommendations_list = array();
    $sql_select = mysqli_query($con, "SELECT * FROM `recommendations_products`;");

    if ($sql_select) {
        if (mysqli_num_rows($sql_select) > 0) {
            while ($recommendation_object = mysqli_fetch_object($sql_select)) {
                $recommendations_list[] = $recommendation_object->product_id;
            }
            $products_list = array();
            
            $ids = implode(',', array_map('intval', $recommendations_list));
            // $sql_select_products = mysqli_query($con, "SELECT * FROM products WHERE product_id IN ($ids);");
            $sql_select_products = mysqli_query($con, "
                    SELECT * FROM products 
                    WHERE product_id IN ($ids)
                    $blocked_ids_sql
                ");

            if (mysqli_num_rows($sql_select_products) > 0){
                while ($row_data = mysqli_fetch_object($sql_select_products)) {
                    $row_data->product_name = $lang == 'en' ? $row_data->product_name_en : $row_data->product_name;
                    $row_data->product_description = $lang == 'en' ? $row_data->product_description_en : $row_data->product_description;
                    
                    
                    
                    
                         $properties =  array(["title"=>"Small", "value"=>0]);
                 $product_id = $row_data->product_id;
    $sql_props = mysqli_query($con, "
        SELECT * 
        FROM product_props 
        WHERE product_id = '$product_id'
    ");
    if ($sql_props && mysqli_num_rows($sql_props)>0) {
        $properties = [];
        while ($prop = mysqli_fetch_assoc($sql_props)) {
            $properties[] = [
                'id'    => $prop['id']    ?? '',
                'name'  => $prop['title'] ?? '',
                'value' => $prop['value'] ?? '',
            ];
        }
    }
            $row_data->properties = $properties ; 
            $row_data->product_colors = json_decode($row_data->product_colors); 
                    
                    
                    
                    
                    
                    // ADD FULL URL FOR IMAGE (recommendations)
                    if (!empty($row_data->product_image) && strpos($row_data->product_image, 'http') !== 0) {
                        $row_data->product_image = "https://api.tiffanyflowers.ae/admin/" . ltrim($row_data->product_image, '/');
                    }
                    
                    // Hide discount information
                    $row_data->old_price = $row_data->product_price * 1;
                    $row_data->new_price = $row_data->product_price;
                    
                    if(!empty(trim($obj['user_id']))){
                        $sql_select_favorite = mysqli_query($con, "SELECT * FROM `favorites` WHERE `favorite_userId` = '$user_id' AND `favorite_productId` = '$row_data->product_id'");
                        if (mysqli_num_rows($sql_select_favorite) > 0) {
                            $row_data->in_favorite = true;
                        } else {
                            $row_data->in_favorite = false;
                        }

                        $sql_select_cart = mysqli_query($con, "SELECT * FROM `cart` WHERE `item_userId` = '$user_id' AND `item_productId` = '$row_data->product_id'");
                        if (mysqli_num_rows($sql_select_cart) > 0) {
                            $row_data->in_cart = true;
                        } else {
                            $row_data->in_cart = false;
                        }
                    }else{
                        $row_data->in_favorite = false;
                        $row_data->in_cart = false;
                    }
                    unset(
                        $row_data->hidden, 
                        $row_data->product_rejectImage, 
                        $row_data->product_rejectReason, 
                        $row_data->product_status,
                        $row_data->product_discount,
                        $row_data->product_price,
                        $row_data->discount_percentage
                    );
                    $products_list[] = $row_data;
                }
            }else {
                $home_data['recommendations_products'] = array();
            }

            $home_data['recommendations_products'] = $products_list;
        } else {
            $home_data['recommendations_products'] = array();
        }
    } else {
        return serverError();
    }
     
     
    // latest_products
    $latest_products = array();
    // $sql_select_latest = mysqli_query($con, "SELECT * FROM `products` ORDER BY `product_id` DESC LIMIT 8;");
    $sql_select_latest = mysqli_query($con, "
        SELECT * FROM `products`
        WHERE 1=1
        $blocked_ids_sql
        ORDER BY `product_id` DESC LIMIT 10
    ");

    if ($sql_select_latest) {
        if (mysqli_num_rows($sql_select_latest) > 0) {
            while ($row_data_latest = mysqli_fetch_object($sql_select_latest)) {
                $row_data_latest->product_name = $lang == 'en' ? $row_data_latest->product_name_en : $row_data_latest->product_name;
                  $properties =  array(["title"=>"Small", "value"=>0]);
                 $product_id = $row_data_latest->product_id;
    $sql_props = mysqli_query($con, "
        SELECT * 
        FROM product_props 
        WHERE product_id = '$product_id'
    ");
    if ($sql_props && mysqli_num_rows($sql_props)>0) {
        $properties = [];
        while ($prop = mysqli_fetch_assoc($sql_props)) {
            $properties[] = [
                'id'    => $prop['id']    ?? '',
                'name'  => $prop['title'] ?? '',
                'value' => $prop['value'] ?? '',
            ];
        }
    }
            $row_data_latest->properties = $properties ; 
            $row_data_latest->product_colors = json_decode($row_data_latest->product_colors); 
                $row_data_latest->product_description = $lang == 'en' ? $row_data_latest->product_description_en : $row_data_latest->product_description;
                
                // ADD FULL URL FOR IMAGE (latest)
                if (!empty($row_data_latest->product_image) && strpos($row_data_latest->product_image, 'http') !== 0) {
                    $row_data_latest->product_image = "https://api.tiffanyflowers.ae/admin/" . ltrim($row_data_latest->product_image, '/');
                }
                
                // Hide discount information
                $row_data_latest->old_price = $row_data_latest->product_price * 1;
                $row_data_latest->new_price = $row_data_latest->product_price;
                
                if(!empty(trim($obj['user_id']))){
                    $sql_select_favorite = mysqli_query($con, "SELECT * FROM `favorites` WHERE `favorite_userId` = '$user_id' AND `favorite_productId` = '$row_data_latest->product_id'");
                    if (mysqli_num_rows($sql_select_favorite) > 0) {
                        $row_data_latest->in_favorite = true;
                    } else {
                        $row_data_latest->in_favorite = false;
                    }

                    $sql_select_cart = mysqli_query($con, "SELECT * FROM `cart` WHERE `item_userId` = '$user_id' AND `item_productId` = '$row_data_latest->product_id'");
                    if (mysqli_num_rows($sql_select_cart) > 0) {
                        $row_data_latest->in_cart = true;
                    } else {
                        $row_data_latest->in_cart = false;
                    }
                }else{
                    $row_data_latest->in_favorite = false;
                    $row_data_latest->in_cart = false;
                }
                unset(
                    $row_data_latest->hidden, 
                    $row_data_latest->product_rejectImage, 
                    $row_data_latest->product_rejectReason, 
                    $row_data_latest->product_status,
                    $row_data_latest->product_discount,
                    $row_data_latest->product_price,
                    $row_data_latest->discount_percentage
                );
                $latest_products[] = $row_data_latest;
            }

            $home_data['latest_products'] = $latest_products;
        } else {
            $home_data['latest_products'] = array();
        }
    } else {
        return serverError();
    }
     
    $response = new stdClass();
    $response->status = "success";
    $response->message = array(
        "categories" => $home_data['categories'],
        "gallary_products" => $home_data['gallary_products'], 
        "recommendations_products" => $home_data['recommendations_products'],
        "latest_products" => $home_data['latest_products'],
        "locations" => $home_data['locations']
    );

    return json_encode($response);
}
