<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require "../connect.php";
require "../lang.php";

$lang = get_current_language();

if ($requestMethod == "POST") {
    $res = makeReview();
    // print_r($res);
    echo $res;
} else {
    echo error405($requestMethod);
}

function makeReview()
{
    global $con;
    global $lang;
    
    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);

    if (!isset($obj['text'])) {
        return error(trans()["review_text_required"][$lang]);
    }
    if (!isset($obj['product_id'])) {
        return error(trans()["product_id_required"][$lang]);
    }
    if (!isset($obj['user_id'])) {
        return error(trans()["user_id_required"][$lang]);
    }
    if (!isset($obj['user_name'])) {
        return error(trans()["user_name_required"][$lang]);
    }
    if (!isset($obj['rate'])) {
        return error(trans()["rate_required"][$lang]);
    }
    

    $text = mysqli_real_escape_string($con, $obj['text']);
    $user_id = mysqli_real_escape_string($con, $obj['user_id']);
    $product_id = mysqli_real_escape_string($con, $obj['product_id']);
    $user_name = mysqli_real_escape_string($con, $obj['user_name']);
    $rate = mysqli_real_escape_string($con, $obj['rate']);
   


    if (empty(trim($obj['text']))) {
        return error(trans()["review_text_required"][$lang]);
    }
    if (empty(trim($obj['user_id']))) {
        return error(trans()["user_id_required"][$lang]);;
    }
    if (empty(trim($obj['product_id']))) {
        return error(trans()["product_id_required"][$lang]);
    }
    if (empty(trim($obj['user_name']))) {
        return error(trans()["user_name_required"][$lang]);
    }
    if (empty(trim($obj['rate']))) {
        return error(trans()["rate_required"][$lang]);
    }

    $sql_select = mysqli_query($con, "SELECT * FROM `users` WHERE `user_id` = '$user_id' AND `ban` = '0'");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error(trans()["user_not_found_or_banned"][$lang]);
    }

    $sql_select = mysqli_query($con, "SELECT * FROM `products` WHERE `product_id` = '$product_id' AND `hidden` = '0'");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error(trans()["product_not_found"][$lang]);
    }

    $sql_select = mysqli_query($con, "INSERT INTO `product_reviews`(`review_text`, `reviewer_name`, `rate`, `user_id`, `product_id`) VALUES ('$text', '$user_name', '$rate', '$user_id', '$product_id')");
    if ($sql_select) {
        return success("review_created_successfully");
    } else {
        return serverError();
    }
}
