<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/../vendor/autoload.php';

ob_start(); 
?>

<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Processing</title>
  <style>

    .spinner {
      width: 56px;
      height: 56px;
      display: grid;
      border-radius: 50%;
      -webkit-mask: radial-gradient(farthest-side, transparent 40%, #22C55E 41%);
      mask: radial-gradient(farthest-side, transparent 40%, #22C55E 41%);
      background:
        linear-gradient(0deg, rgba(34,197,94,.5) 50%, rgba(34,197,94,1) 0) center/4.5px 100% no-repeat,
        linear-gradient(90deg, rgba(34,197,94,.25) 50%, rgba(34,197,94,.75) 0) center/100% 4.5px no-repeat;
      animation: spinner-d3o0rx 1s infinite steps(12);
    }
    .spinner::before,
    .spinner::after {
      content: "";
      grid-area: 1/1;
      border-radius: 50%;
      background: inherit;
      opacity: 0.915;
      transform: rotate(30deg);
    }
    .spinner::after {
      opacity: 0.83;
      transform: rotate(60deg);
    }
    @keyframes spinner-d3o0rx {
      100% { transform: rotate(1turn); }
    }

    .fullscreen-loader {
      width: 100vw;
      height: 100vh;
      background: linear-gradient(135deg, #0f2027 0%, #203a43 50%, #2c5530 100%);
      display: flex;
      align-items: center;
      justify-content: center;
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      z-index: 9999;
      overflow: hidden;
    }

    .fullscreen-loader::before {
      content: '';
      position: absolute;
      width: 200%;
      height: 200%;
      background:
        radial-gradient(circle at 20% 80%, rgba(34, 197, 94, 0.15) 0%, transparent 50%),
        radial-gradient(circle at 80% 20%, rgba(16, 185, 129, 0.15) 0%, transparent 50%),
        radial-gradient(circle at 40% 40%, rgba(74, 222, 128, 0.1) 0%, transparent 50%);
      animation: float 20s ease-in-out infinite;
    }

    @keyframes float {
      0%, 100% { transform: translate(-50%, -50%) rotate(0deg); }
      50% { transform: translate(-50%, -50%) rotate(180deg); }
    }

    .loading-box {
      display: flex;
      flex-direction: column;
      align-items: center;
      padding: 3rem;
      border-radius: 20px;
      background: rgba(15, 32, 39, 0.4);
      backdrop-filter: blur(10px);
      border: 1px solid rgba(34, 197, 94, 0.2);
      box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3), 0 0 80px rgba(34, 197, 94, 0.1);
      position: relative;
      z-index: 10;
    }

    .loading-box::before {
      content: '';
      position: absolute;
      inset: 0;
      border-radius: 20px;
      background: linear-gradient(45deg, rgba(34, 197, 94, 0.1) 0%, transparent 50%, rgba(16, 185, 129, 0.1) 100%);
      animation: shimmer 3s ease-in-out infinite;
    }

    @keyframes shimmer {
      0%, 100% { opacity: 0.5; }
      50% { opacity: 1; }
    }

    .processing {
      color: #e2e8f0;
      font-family: "Fira Sans", sans-serif;
      font-size: 18px;
      font-weight: 500;
      margin-top: 20px;
      margin-bottom: 15px;
      letter-spacing: 0.5px;
      text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
    }

    .loading-dots {
      display: flex;
      gap: 8px;
    }

    .dot {
      width: 10px;
      height: 10px;
      background: linear-gradient(45deg, #22C55E, #16A34A);
      border-radius: 50%;
      opacity: 0.6;
      box-shadow: 0 0 10px rgba(34, 197, 94, 0.5);
    }

    .dot:nth-child(1) { animation: pulse 1.5s infinite 0s; }
    .dot:nth-child(2) { animation: pulse 1.5s infinite 0.3s; }
    .dot:nth-child(3) { animation: pulse 1.5s infinite 0.6s; }

    @keyframes pulse {
      0%, 100% {
        opacity: 0.6;
        transform: scale(1);
        box-shadow: 0 0 10px rgba(34, 197, 94, 0.5);
      }
      50% {
        opacity: 1;
        transform: scale(1.3);
        box-shadow: 0 0 20px rgba(34, 197, 94, 0.8);
      }
    }
  </style>
</head>
<body>
  <div class="fullscreen-loader">
    <div class="loading-box">
      <div class="simple-loader">
        <div class="spinner"></div>
      </div>
      <p class="processing">Processing</p>
      <div class="loading-dots">
        <span class="dot"></span>
        <span class="dot"></span>
        <span class="dot"></span>
      </div>
    </div>
  </div>
</body>
</html>

<?php
flush(); 
sleep(3);


$data = json_decode(file_get_contents("php://input"), true);
$order_id = $data['order_id'] ?? null;
$total = $data['total'] ?? null;
$products = $data['products'] ?? null;

if (!$order_id || !$total || !is_array($products)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid request data']);
    exit;
}

\Stripe\Stripe::setApiKey('sk_test_51KUaMQHqjMTmDcrpiaM7Pl3inGpggUTqwG2b1dnGuBmsuVPMhc3g0UPnm38WEPTmVXcR4FLlF0afGkj32LV4lyac00OO0CkTcT');

try {
    $checkoutSession = \Stripe\Checkout\Session::create([
        'payment_method_types' => ['card'],
        'mode' => 'payment',
        'line_items' => [[
            'price_data' => [
                'currency' => 'eur',
                'product_data' => ['name' => 'Your Product'],
                'unit_amount' => intval($total),
            ],
            'quantity' => 1,
        ]],
        'success_url' => 'https://yourdomain.com/success',
        'cancel_url' => 'https://yourdomain.com/cancel',
    ]);

    header("Location: " . $checkoutSession->url);
    exit;

} catch (\Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>
