<?php
// /user/payment_cancel.php

ini_set('display_errors', 1); // set to 0 in production
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/order-error.log');

require 'vendor/autoload.php';
// \Stripe\Stripe::setApiKey('sk_test_51MbycxKqjaL0X49YF3I3ZZ81fF772xlz4XB90p4nDxdYFWR4CyxOljSTiZy26eS3V9dZFrNotiSA8maUnAlmQG5M00dZqUUuCS');
\Stripe\Stripe::setApiKey('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');
$order_id   = isset($_GET['order_id']) ? (int)$_GET['order_id'] : 0;
$session_id = $_GET['session_id'] ?? '';

$dbError        = '';
$updated        = false;
$alreadyUpdated = false;
$currentStatus  = null;
$paymentStatus  = null; // what we show here by default
$stripeStatus   = null;

if ($order_id > 0 && $session_id) {
    try {
        $session = \Stripe\Checkout\Session::retrieve($session_id);

        if (!empty($session->payment_intent)) {
            $pi = \Stripe\PaymentIntent::retrieve($session->payment_intent);
            $stripeStatus = $pi->status;

            // If by any chance payment actually succeeded, don't mark cancelled
            if ($stripeStatus === 'succeeded') {
                $paymentStatus = 'success';
            } elseif (in_array($stripeStatus, [
                'canceled',
                'requires_payment_method'
            ], true)) {
                $paymentStatus = 'failed';
            } else {
                // processing / requires_action → treat as pending/cancelled UX wise
                $paymentStatus = 'cancelled';
            }
        } else {
            // Fallback to Checkout Session status if no PaymentIntent
            $stripeStatus = $session->payment_status ?? null; // 'paid', 'unpaid', 'no_payment_required'
            if ($stripeStatus === 'paid') {
                $paymentStatus = 'success';
            } else {
                $paymentStatus = 'failed';
            }
        }

        require __DIR__ . '/../connect.php';
        if (isset($con) && $con instanceof mysqli && !$con->connect_error) {
            $stmt = $con->prepare("SELECT payment_status FROM orders WHERE order_id = ?");
            if ($stmt) {
                $stmt->bind_param('i', $order_id);
                $stmt->execute();
                $res = $stmt->get_result();
                $row = $res->fetch_assoc();
                $stmt->close();

                if ($row) {
                    $currentStatus = $row['payment_status'];

                    // Only update if still NULL / '' / 'pending'
                    if ($currentStatus === null ||
                        $currentStatus === '' ||
                        strtolower($currentStatus) === 'pending') {

                        // If Stripe says success, set success, otherwise cancelled
                        $newStatus = ($paymentStatus === 'success') ? 'success' : 'cancelled';

                        $stmt2 = $con->prepare("UPDATE orders SET payment_status = ? WHERE order_id = ?");
                        if ($stmt2) {
                            $stmt2->bind_param('si', $newStatus, $order_id);
                            $stmt2->execute();
                            $stmt2->close();
                            $updated       = true;
                            $currentStatus = $newStatus;
                        } else {
                            $dbError = 'Failed to prepare update statement: ' . $con->error;
                        }
                    } else {
                        $alreadyUpdated = true;
                        if (!empty($currentStatus)) {
                            $paymentStatus = $currentStatus;
                        }
                    }
                } else {
                    $dbError = 'Order not found.';
                }
            } else {
                $dbError = 'Failed to prepare select statement: ' . $con->error;
            }
        } else {
            $dbError = 'Database connection error.';
        }

    } catch (Throwable $e) {
        $dbError = 'Stripe exception: ' . $e->getMessage();
    }
} else {
    $dbError = 'Missing order_id or session_id in URL.';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Payment Cancelled - Tiffany Flowers</title>
    <style>
        :root {
            --primary: #f97373;
            --bg: #fff1f2;
            --text: #3f2a36;
        }
        * { margin:0; padding:0; box-sizing:border-box; }
        body {
            min-height: 100vh;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: radial-gradient(circle at top, #ffe4e6 0, #fff1f2 40%, #fee2e2 100%);
            display:flex;
            align-items:center;
            justify-content:center;
            color:var(--text);
        }
        .card {
            background:#fff;
            max-width:480px;
            width:100%;
            padding:30px 26px 26px;
            border-radius:18px;
            box-shadow:0 18px 35px rgba(248,113,113,0.25);
            text-align:center;
            position: relative;
            overflow: hidden;
        }
        .card::before {
            content: "";
            position: absolute;
            inset: -30%;
            background:
              radial-gradient(circle at 0 0, rgba(248,113,113,0.18), transparent 55%),
              radial-gradient(circle at 100% 0, rgba(251,113,133,0.15), transparent 60%);
            opacity: 0.7;
            z-index: -1;
        }
        .icon-circle {
            width:64px; height:64px;
            border-radius:999px;
            margin:0 auto 16px;
            display:flex;
            align-items:center;
            justify-content:center;
            background:radial-gradient(circle at 30% 0, #fecaca, #ef4444);
            box-shadow: 0 12px 30px rgba(239,68,68,0.45);
        }
        .icon-circle svg {
            width:32px; height:32px;
            color:#fff;
        }
        h1 { font-size:1.5rem; margin-bottom:6px; }
        .subtitle {
            font-size:0.95rem;
            color:#7a4b5d;
            margin-bottom:18px;
        }
        .order {
            font-size:0.9rem;
            margin-bottom:14px;
            color:#7a4b5d;
        }
        .status-label {
            display:inline-block;
            padding:4px 10px;
            border-radius:999px;
            font-size:0.75rem;
            text-transform:uppercase;
            letter-spacing:.06em;
            background:rgba(248,113,113,0.1);
            color:#b91c1c;
            margin-bottom:18px;
        }
        .btn {
            display:inline-flex;
            align-items:center;
            justify-content:center;
            padding:10px 20px;
            border-radius:999px;
            border:none;
            cursor:pointer;
            font-size:0.95rem;
            font-weight:600;
            background:#111827;
            color:#fff;
            text-decoration:none;
            transition: transform .15s ease, box-shadow .15s ease;
            box-shadow:0 10px 25px rgba(15,23,42,0.35);
        }
        .btn:hover {
            transform: translateY(-1px);
            box-shadow:0 14px 30px rgba(15,23,42,0.45);
        }
        .note {
            margin-top:10px;
            font-size:0.8rem;
            color:#9b6b7b;
        }
        .debug {
            margin-top:12px;
            font-size:0.75rem;
            color:#7f1d1d;
            background:rgba(254,226,226,0.9);
            border-radius:8px;
            padding:8px 10px;
            text-align:left;
            max-width:420px;
            margin-left:auto;
            margin-right:auto;
            white-space:pre-wrap;
        }
    </style>
</head>
<body>
<div class="card">
    <div class="icon-circle">
        <svg viewBox="0 0 24 24" fill="none">
            <circle cx="12" cy="12" r="9" stroke="white" stroke-width="2"/>
            <path d="M9 9L15 15M15 9L9 15" stroke="white" stroke-width="2" stroke-linecap="round"/>
        </svg>
    </div>
    <h1>Payment cancelled</h1>
    <p class="subtitle">
        Your payment was not completed. No money has been taken from your card.
    </p>

    <p class="order">
        <?php if ($order_id): ?>
            Order #: <strong><?php echo htmlspecialchars($order_id); ?></strong>
        <?php else: ?>
            We couldn’t detect a valid order number.
        <?php endif; ?>
    </p>

    <div class="status-label">
        Status: <?php echo ucfirst($paymentStatus); ?>
    </div>

    <a class="btn" href="https://tiffanyflowers.ae/cart">
        Back to cart
    </a>

    <p class="note">
        You can try again or choose another payment method at any time.
    </p>

    <?php if ($dbError): ?>
        <div class="debug">
            <strong>Debug info (remove in production):</strong><br>
            <?php echo htmlspecialchars($dbError); ?>
        </div>
    <?php elseif ($alreadyUpdated): ?>
        <div class="debug">
            Payment status was already "<?php echo htmlspecialchars((string)$currentStatus); ?>" — not changed.
        </div>
    <?php elseif ($updated): ?>
        <div class="debug">
            Payment status updated to "<?php echo htmlspecialchars((string)$currentStatus); ?>" for order #<?php echo htmlspecialchars($order_id); ?>.
        </div>
    <?php endif; ?>
</div>
</body>
</html>
