<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require "../../connect.php";
require "../../lang.php";

$lang = get_current_language();

if ($requestMethod == "POST") {
    $res = createReport();
    echo $res;
} else {
    echo error405($requestMethod);
}

function createReport()
{
    global $con;
    global $lang;
    
    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);

    if (!isset($obj['note'])) {
        return error(trans()["report_note_required"][$lang]);
    }
    if (!isset($obj['option_id'])) {
         return error(trans()["report_option_required"][$lang]);
    }
    if (!isset($obj['sub_option_id'])) {
        return error(trans()["report_sub_option_required"][$lang]);
    }
    if (!isset($obj['user_id'])) {
        return error(trans()["user_id_required"][$lang]);
    }
    if (!isset($obj['contact_name'])) {
         return error(trans()["contact_name_required"][$lang]);
    }
    if (!isset($obj['contact_email'])) {
        return error(trans()["contact_email_required"][$lang]);
    }
    if (!isset($obj['product_id'])) {
       return error(trans()["product_id_required"][$lang]);
    }
    

    $note = mysqli_real_escape_string($con, $obj['note']);
    $user_id = mysqli_real_escape_string($con, $obj['user_id']);
    $option_id = mysqli_real_escape_string($con, $obj['option_id']);
    $sub_option_id = mysqli_real_escape_string($con, $obj['sub_option_id']);
    $contact_name = mysqli_real_escape_string($con, $obj['contact_name']);
    $contact_email = mysqli_real_escape_string($con, $obj['contact_email']);
    $product_id = mysqli_real_escape_string($con, $obj['product_id']);


    if (empty(trim($obj['user_id']))) {
        return error(trans()["user_id_required"][$lang]);
    }
    if (empty(trim($obj['option_id']))) {
        return error(trans()["report_option_required"][$lang]);
    }
    if (empty(trim($obj['sub_option_id']))) {
        return error(trans()["report_sub_option_required"][$lang]);
    }
    if (empty(trim($obj['contact_name']))) {
        return error(trans()["contact_name_required"][$lang]);;
    }
    if (empty(trim($obj['contact_email']))) {
        return error(trans()["contact_email_required"][$lang]);
    }
    if (empty(trim($obj['product_id']))) {
        return error(trans()["product_id_required"][$lang]);
    }

    $sql_select = mysqli_query($con, "SELECT * FROM `users` WHERE `user_id` = '$user_id' AND `ban` = '0'");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error(trans()["user_not_found_or_banned"][$lang]);
    }

    $sql_select = mysqli_query($con, "SELECT * FROM `report_options` WHERE `option_id` = '$option_id'");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
       return error(trans()["report_option_not_found"][$lang]);
    }
    
    $sql_select = mysqli_query($con, "SELECT * FROM `report_sub_options` WHERE `sub_id` = '$sub_option_id' AND `option_id` = '$option_id'");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
         return error(trans()["report_sub_option_not_found"][$lang]);   
    }
    
    $sql_select = mysqli_query($con, "SELECT * FROM `products` WHERE `product_id` = '$product_id' AND `hidden` = '0'");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error(trans()["product_not_found"][$lang]);
    }

    $sql_select = mysqli_query($con, "INSERT INTO `reports`(`option_id`, `sub_option_id`, `note`, `contact_name`, `contact_email`, `user_id`, `product_id`) VALUES ('$option_id', '$sub_option_id', '$note', '$contact_name', '$contact_email', '$user_id', '$product_id')");
    if ($sql_select) {
         return success(trans()["report_created_successfully"][$lang]);
    } else {
        return serverError();
    }
}
