<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require "../connect.php";
require "../lang.php";

$lang = get_current_language();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);

    if (!isset($obj['user_id'])) {
        echo json_encode([
            "status" => 400,
            "message" => trans()["user_id_required"][$lang]
        ]);
        exit;
    }
    
    $user_id = mysqli_real_escape_string($con, $obj['user_id']);
    $sql =  "SELECT user_blocks.user_blocked_id, users.user_name 
        FROM user_blocks 
        LEFT JOIN users ON user_blocks.user_blocked_id = users.user_id 
        WHERE user_blocks.user_id = '$user_id'";
    $result = mysqli_query($con, $sql);

    $data = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $data[] = $row;
    }

    echo json_encode([
        "status" => 200,
        "message" => $data
    ]);

} else {
    echo json_encode([
        "status" => 405,
        "message" => trans()["method_not_allowed"][$lang]
    ]);
    exit;
}
